# Zatca integration notes
### Zatca Integration have two steps first : OnBoarding Step example :

# zatca available gates : 

'developer-portal' sanbox accept any otp
'simulation' accept otp from fatoora portal
'core' mean live  accept otp from fatoora portal

# invoices types : 
 1100 for together  
 0100 for simplified
 1000 for standard

```php

    use Allam\Zatca\OnBoarding;
    $response = (new OnBoarding())
    ->setZatcaEnv('developer-portal')
    ->setZatcaLang('en')
    ->setEmailAddress('email@gmail.com')
    ->setCommonName('TSTCO') // company name
    ->setCountryCode('SA')
    ->setOrganizationUnitName('TSTCO-SA') // branch name or company name
    ->setOrganizationName('TSTCO-SA') // branch name or company name
    ->setEgsSerialNumber('1-SDSA|2-FGDS|3-SDFG') // unique identifier (device name)
    ->setVatNumber('300000000000003') // vat number
    ->setInvoiceType('1100') // invoice type
    ->setRegisteredAddress('RMRE1234') // short address from national address card
    ->setAuthOtp('111222') // stage otp
    ->setBusinessCategory('Transportations') // bussiness category as free text
    ->getAuthorization();
```
- you can print previous response as you want to handle it into your system

*******************
### Zatca Integration have two steps second : Send Invoices to zatca Step example :
#### before send invoice important : 
create zatca_documents table
```php
 CREATE TABLE `zatca_documents` (
  `icv` varchar(191) NOT NULL, // autoincreament  for example : 1 [manipulate]
  `uuid` varchar(191) NOT NULL, // for example : 8d487816-70b8-4ade-a618-9d620b73814a [manipluate]
  `hash` varchar(191) NULL, // [response]
  `xml` longtext DEFAULT NULL,// [response]
  `sent_to_zatca` tinyint(1)  NULL,// [response]
  `sent_to_zatca_status` varchar(191)  NULL,// [response]
  `signing_time` datetime DEFAULT NULL,// [response]
  `response` longtext DEFAULT NULL,// [response]
  `invoice_id` varchar(191) NOT NULL // local invoice id from my database like invoices table
)
```
```php
1-  before send invoice to zatca will initiate record into zatca documents will have auto icv value ex: (1) and with uuid value
2-   then check this record is first record or not
3-  it not prevoius hash value will be (PIH) $prevoius_hash = base64_encode(hash('sha256','0',true));
4-  else initiated recored have prevoius record $prevoius_hash = $prevRecord->hash;
5-  then after invoice is sent will get hash , xml , response and status then update initiated record
6 - generate uuid value and store it for initiated recored and it will be used below
```
```php
    use Allam\Zatca\Invoice\Client;
    use Allam\Zatca\Invoice\Supplier;
    use Allam\Zatca\Invoice\Delivery;
    use Allam\Zatca\Invoice\PaymentType;
    use Allam\Zatca\Invoice\PIH;
    use Allam\Zatca\Invoice\ReturnReason;
    use Allam\Zatca\Invoice\BillingReference;
    use Allam\Zatca\Invoice\AdditionalDocumentReference;
    use Allam\Zatca\Invoice\LegalMonetaryTotal;
    use Allam\Zatca\Invoice\TaxesTotal;
    use Allam\Zatca\Invoice\TaxSubtotal;
    use Allam\Zatca\Invoice\LineTaxCategory;
    use Allam\Zatca\Invoice\InvoiceLine;
    use Allam\Zatca\Invoice\AllowanceCharge;
    use Allam\Zatca\Invoice\InvoiceGenerator;

    $client = (new Client()) // if client have tax number  : tax number and national address will be required else country and name only required
    ->setVatNumber('300000000000003')
    ->setStreetName('STREET')
    ->setBuildingNumber('1111')
    ->setPlotIdentification('2223')
    ->setSubDivisionName('JEDDAH')
    ->setCityName('JEDDAH')
    ->setPostalNumber('12222')
    ->setCountryName('SA')
    ->setClientName('TSTCO');

    $supplier = (new Supplier()) // all data here must be required
    ->setCrn('1000000000')
    ->setStreetName('RIYADH')
    ->setBuildingNumber('2322')
    ->setPlotIdentification('2223')
    ->setSubDivisionName('RIYADH')
    ->setCityName('RIYADH')
    ->setPostalNumber('11633')
    ->setCountryName('SA')
    ->setVatNumber('300000000000003')
    ->setVatName('TSTCO');

    $delivery = (new Delivery()) // invoice expected delievery date
    ->setDeliveryDateTime('2022-09-07');

    $paymentType = (new PaymentType()) // invoice payment type  : reference  : https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/Documents/20220624_ZATCA_Electronic_Invoice_XML_Implementation_Standard_vF.pdf , section : 11.2.5 Payment means type code
    ->setPaymentType('10');

    $returnReason = (new ReturnReason()) // invoice return reason if invoice credit note or debit note
    ->setReturnReason('SET_RETURN_REASON');

    $previous_hash = (new PIH())
    ->setPIH('X+zrZv/IbzjZUnhsbWlsecLbwjndTpG0ZynXOif7V+k=');  // note this value it from step 3 , 4

    $billingReference = (new BillingReference())
    ->setBillingReference('23'); // note this used when type credit or debit this value of parent invoice id

    $additionalDocumentReference = (new AdditionalDocumentReference())
    ->setInvoiceID('55'); // note this value it from step 1 invoice counter value icv

    $legalMonetaryTotal = (new LegalMonetaryTotal()) // invoice totals
    ->setTotalCurrency('SAR')
    ->setLineExtensionAmount(4)
    ->setTaxExclusiveAmount(4)
    ->setTaxInclusiveAmount(4.60)
    ->setAllowanceTotalAmount(0)
    ->setPrepaidAmount(0)
    ->setPayableAmount(4.60);

    $taxesTotal = (new TaxesTotal()) // invoice tax totals
    ->setTaxCurrencyCode('SAR')
    ->setTaxTotal(0.60);

    $taxSubtotal = (new TaxSubtotal()) // invoice subtotal accept total before tax and tax amount and tax percentage
    ->setTaxCurrencyCode('SAR')
    ->setTaxableAmount(4.00)
    ->setTaxAmount(0.60)
    ->setTaxCategory('S')
    ->setTaxPercentage(15)
    ->getElement();

    $itemTaxCategory = (new LineTaxCategory()) // declare line tax details like code and percentage , reference :https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/Documents/20220624_ZATCA_Electronic_Invoice_XML_Implementation_Standard_vF.pdf follow seaction :  11.2.4 VAT categories code
    ->setTaxCategory('S')
    ->setTaxPercentage(15)
    ->getElement();

    $invoiceLines[] = (new InvoiceLine())
    ->setLineID('1')
    ->setLineName('TST Item')
    ->setLineCurrency('SAR')
    ->setLinePrice(2)
    ->setLineQuantity(2)
    ->setLineSubTotal(4)
    ->setLineTaxTotal(0.60)
    ->setLineNetTotal(4.60)
    ->setLineTaxCategories($itemTaxCategory)
    ->setLineDiscountReason('reason')
    ->setLineDiscountAmount(0)
    ->getElement();
    $invoiceLines[] = (new InvoiceLine())
    ->setLineID('1')
    ->setLineName('TST Item')
    ->setLineCurrency('SAR')
    ->setLinePrice(2)
    ->setLineQuantity(2)
    ->setLineSubTotal(4)
    ->setLineTaxTotal(0.60)
    ->setLineNetTotal(4.60)
    ->setLineTaxCategories($itemTaxCategory)
    ->setLineDiscountReason('reason')
    ->setLineDiscountAmount(0)
    ->getElement();

    $allowanceCharge = (new AllowanceCharge()) // this invoice discount total
    ->setAllowanceChargeCurrency('SAR')
    ->setAllowanceChargeIndex('1')
    ->setAllowanceChargeAmount(0)
    ->setAllowanceChargeTaxCategory('S')
    ->setAllowanceChargeTaxPercentage(15)
    ->getElement();

    $response = (new InvoiceGenerator())
    ->setZatcaEnv('developer-portal')
    ->setZatcaLang('en')
    ->setInvoiceNumber('SME00023')
    ->setInvoiceUuid('8d487816-70b8-4ade-a618-9d620b73814a') // this value from step 6
    ->setInvoiceIssueDate('2022-09-07')
    ->setInvoiceIssueTime('12:21:28')
    ->setInvoiceType('0200000','388')  // 0200000 simplified (B2C) , 0100000 standard (B2B)   //'388', // NORMAL INVOICE (SALES) , '383', // DEBIT_NOTE , '381'  // CREDIT_NOTE
    ->setInvoiceCurrencyCode('SAR')
    ->setInvoiceTaxCurrencyCode('SAR')
    //->setInvoiceBillingReference($billingReference)  use this when document type is credit or debit
    ->setInvoiceAdditionalDocumentReference($additionalDocumentReference)
    ->setInvoicePIH($previous_hash)
    ->setInvoiceSupplier($supplier)
    ->setInvoiceClient($client)
    ->setInvoiceDelivery($delivery)
    ->setInvoicePaymentType($paymentType)
    //->setInvoiceReturnReason($returnReason) use this when document type is credit or debit
    ->setInvoiceLegalMonetaryTotal($legalMonetaryTotal)
    ->setInvoiceTaxesTotal($taxesTotal)
    ->setInvoiceTaxSubTotal($taxSubtotal)
    ->setInvoiceAllowanceCharges($allowanceCharge)
    ->setInvoiceLines(...$invoiceLines)
    ->setCertificateEncoded("TUlJQjVUQ0NBWXFnQXdJQkFnSUdBWStPTTBOR01Bb0dDQ3FHU000OUJBTUNNQlV4RXpBUkJnTlZCQU1NQ21WSmJuWnZhV05wYm1jd0hoY05NalF3TlRFNU1EQXhORE13V2hjTk1qa3dOVEU0TWpFd01EQXdXakJETVE0d0RBWURWUVFEREFWVVUxUkRUekVSTUE4R0ExVUVDd3dJVkZOVVEwOHRVMEV4RVRBUEJnTlZCQW9NQ0ZSVFZFTlBMVk5CTVFzd0NRWURWUVFHRXdKVFFUQldNQkFHQnlxR1NNNDlBZ0VHQlN1QkJBQUtBMElBQkFsbnRVditjUkFJU0JSekFKTWFSUHdrRE5JblZKdGNXV3l1UWdYN0k2U0s0QytTSU1JQ0psYzN2YXhkYUpQc2pRUlJ4VHE3eDZCbnZHS09JUTVMdDNLamdab3dnWmN3REFZRFZSMFRBUUgvQkFJd0FEQ0JoZ1lEVlIwUkJIOHdmYVI3TUhreEhUQWJCZ05WQkFRTUZERXRVMFJUUVh3eUxVWkhSRk44TXkxVFJFWkhNUjh3SFFZS0NaSW1pWlB5TEdRQkFRd1BNekF3TURBd01EQXdNREF3TURBek1RMHdDd1lEVlFRTURBUXhNVEF3TVE0d0RBWURWUVFhREFWVFFWVkVTVEVZTUJZR0ExVUVEd3dQVkhKaGJuTndiM0owWVhScGIyNXpNQW9HQ0NxR1NNNDlCQU1DQTBrQU1FWUNJUUNIUDZEMDVNRm9rU1lickdNV2RPVzhqL1htU0lwdURwUDRId25IckRxOFFBSWhBTEZ2THg4NGRvUWpaa0U0M1JKZzFXYWdVcm9XQkNpN0kzWk9RdVlCNk9Ibg==")
    ->setPrivateKeyEncoded("LS0tLS1CRUdJTiBQUklWQVRFIEtFWS0tLS0tCk1JR0VBZ0VBTUJBR0J5cUdTTTQ5QWdFR0JTdUJCQUFLQkcwd2F3SUJBUVFnb0pYTGxHRDE4MXZaaFgrUzRDMTQKODRURGVJUWV6dmtKR2l5TkdNZktjck9oUkFOQ0FBUUpaN1ZML25FUUNFZ1Vjd0NUR2tUOEpBelNKMVNiWEZscwpya0lGK3lPa2l1QXZraURDQWlaWE43MnNYV2lUN0kwRVVjVTZ1OGVnWjd4aWppRU9TN2R5Ci0tLS0tRU5EIFBSSVZBVEUgS0VZLS0tLS0K")
    ->setCertificateSecret("srtiZ72Dx+YySBGO22hmr5UEaul5HKl8snfTfUnc/vY=")
    ->sendDocument(); // when you use production certifiacte for (simulation , core) dont forget set sendDocument(true)
```
- important note : returned data update it to initiated row from step 1