<?php
include "./vendor/autoload.php";
use Allam\Zatca\Invoice\Client;
use Allam\Zatca\Invoice\Supplier;
use Allam\Zatca\Invoice\Delivery;
use Allam\Zatca\Invoice\PaymentType;
use Allam\Zatca\Invoice\PIH;
use Allam\Zatca\Invoice\ReturnReason;
use Allam\Zatca\Invoice\BillingReference;
use Allam\Zatca\Invoice\AdditionalDocumentReference;
use Allam\Zatca\Invoice\LegalMonetaryTotal;
use Allam\Zatca\Invoice\TaxesTotal;
use Allam\Zatca\Invoice\TaxSubtotal;
use Allam\Zatca\Invoice\LineTaxCategory;
use Allam\Zatca\Invoice\InvoiceLine;
use Allam\Zatca\Invoice\AllowanceCharge;
use Allam\Zatca\Invoice\InvoiceGenerator;

use Allam\Zatca\DataBase;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;

$database = new DataBase();

$conn = $database->getConnection();

function generateUUIDv4() {
        $data = random_bytes(16); 
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Set version to 0100 
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Set bits 6-7 to 10 
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4)); 
    }
    
$invoice_id = "25646" ;
$sql = $conn->prepare("SELECT * from vatENV where id = 1");
$sql->execute();
$vatENV = $sql->fetch();

$sql = $conn->prepare("SELECT * FROM `supplier`");
$sql->execute();
$dbSupplier = $sql->fetch();

$sql = $conn->prepare("SELECT * from prevat where IRN = ?");
$sql->bindParam(1,$invoice_id);
$sql->execute();
$preVAT = $sql->fetch();

$max = $conn->prepare("SELECT `icv` , `hash`  FROM `zatca_documents` where icv = (SELECT MAX(`icv`) as icv from zatca_documents)");
$max->execute();

$maxRow = $max->fetch();
$icv    = $maxRow['icv'];
$pih    = $maxRow['hash'];

$uuid   = generateUUIDv4() ;

    if(empty($icv)){    $icv = 1 ;
    
    }else{
    $icv = $icv + 1;
    }
if(empty($pih)){
   $pih = base64_encode(hash('sha256','0',true));
    }

    $sql = $conn->prepare("INSERT INTO zatca_documents(icv,uuid , invoice_id )
                        VALUES (? , ?, ?)");

    $sql->bindParam(1,$icv);
    $sql->bindParam(2,$uuid);
    $sql->bindParam(3,$invoice_id);
    $sql->execute();

$vatNumber = $preVAT['VatNumber'] ;
if(empty($vatNumber)){
    $client = (new Client())
->setCountryName('SA')
->setClientName($preVAT['ClientName']);
$InvoiceType = '0200000';
$message_key = "reportingStatus";
}else{
    $client = (new Client())
->setVatNumber($vatNumber)
->setStreetName($preVAT['ClientName'])
->setBuildingNumber($preVAT['BuildingNumber'])
->setPlotIdentification($preVAT['PlotIdentification'])
->setSubDivisionName($preVAT['SubDivisionName'])
->setCityName($preVAT['CityName'])
->setPostalNumber($preVAT['PostalNumber'])
->setCountryName($preVAT['CountryName'])
->setClientName($preVAT['ClientName']);
$InvoiceType = '0100000';
$message_key = "clearanceStatus";
}


$supplier = (new Supplier())
->setCrn($dbSupplier['Crn'])
->setStreetName($dbSupplier['StreetName'])
->setBuildingNumber($dbSupplier['BuildingNumber'])
->setPlotIdentification($dbSupplier['PlotIdentification'])
->setSubDivisionName($dbSupplier['SubDivisionName'])
->setCityName($dbSupplier['CityName'])
->setPostalNumber($dbSupplier['PostalNumber'])
->setCountryName('SA')
->setVatNumber($dbSupplier['VatNumber'])
->setVatName($dbSupplier['VatName']);

$delivery = (new Delivery())
->setDeliveryDateTime($preVAT['DeliveryDateTime']);

$paymentType = (new PaymentType())
->setPaymentType('10');

$returnReason = (new ReturnReason())
->setReturnReason('SET_RETURN_REASON');

$previous_hash = (new PIH())
->setPIH($pih); 

$billingReference = (new BillingReference())
->setBillingReference('23'); // note this used when type credit or debit this value of parent invoice id

$additionalDocumentReference = (new AdditionalDocumentReference())
->setInvoiceID($icv); 

$legalMonetaryTotal = (new LegalMonetaryTotal())
->setTotalCurrency('SAR')
->setLineExtensionAmount($preVAT['LineExtensionAmount'])
->setTaxExclusiveAmount($preVAT['TaxExclusiveAmount'])
->setTaxInclusiveAmount($preVAT['TaxInclusiveAmount'])
->setAllowanceTotalAmount($preVAT['AllowanceTotalAmount'])
->setPrepaidAmount($preVAT['PrepaidAmount'])
->setPayableAmount($preVAT['PayableAmount']);

$taxesTotal = (new TaxesTotal())
->setTaxCurrencyCode('SAR')
->setTaxTotal($preVAT['TaxTotal']);

$taxSubtotal = (new TaxSubtotal())
->setTaxCurrencyCode('SAR')
->setTaxableAmount($preVAT['TaxableAmount'])
->setTaxAmount($preVAT['TaxAmount'])
->setTaxCategory('S')
->setTaxPercentage(15)
->getElement();

$itemTaxCategory = (new LineTaxCategory())
->setTaxCategory('S')
->setTaxPercentage(15)
->getElement();

$sql = $conn->prepare("SELECT * FROM `invoiceline` WHERE `invoiceID` = ?");
$sql->bindParam(1,$invoice_id);
$sql->execute();

while ($dbLines = $sql->fetch()) {

    $invoiceLines[] = (new InvoiceLine())
    ->setLineID($dbLines['LineID'])
    ->setLineName($dbLines['LineName'])
    ->setLineCurrency('SAR')
    ->setLinePrice($dbLines['LinePrice'])
    ->setLineQuantity($dbLines['LineQuantity'])
    ->setLineSubTotal($dbLines['LineSubTotal'])
    ->setLineTaxTotal($dbLines['LineTaxTotal'])
    ->setLineNetTotal($dbLines['LineNetTotal'])
    ->setLineTaxCategories($itemTaxCategory)
    ->setLineDiscountReason('reason')
    ->setLineDiscountAmount(0.0)
    ->getElement();
}


$allowanceCharge = (new AllowanceCharge())
->setAllowanceChargeCurrency('SAR')
->setAllowanceChargeIndex($preVAT['AllowanceChargeIndex'])
->setAllowanceChargeAmount($preVAT['AllowanceChargeAmount'])
->setAllowanceChargeTaxCategory('S')
->setAllowanceChargeTaxPercentage($preVAT['AllowanceChargeTaxPercentage'])
->getElement();


$response = (new InvoiceGenerator())
->setZatcaEnv($vatENV['ZatcaEnv'])//'developer-portal'
->setZatcaLang('en')
->setInvoiceNumber($preVAT['InvoiceID'])
->setInvoiceUuid($uuid)// how to generate
->setInvoiceIssueDate('2025-03-05')
->setInvoiceIssueTime('12:21:28')
->setInvoiceType($InvoiceType,'388')//0100000 company or 0200000  normal customer
->setInvoiceCurrencyCode('SAR')
->setInvoiceTaxCurrencyCode('SAR')
//->setInvoiceBillingReference($billingReference)  use this when document type is credit or debit
->setInvoiceAdditionalDocumentReference($additionalDocumentReference)
->setInvoicePIH($previous_hash)
->setInvoiceSupplier($supplier)
->setInvoiceClient($client)
->setInvoiceDelivery($delivery)
->setInvoicePaymentType($paymentType)
//->setInvoiceReturnReason($returnReason) use this when document type is credit or debit
->setInvoiceLegalMonetaryTotal($legalMonetaryTotal)
->setInvoiceTaxesTotal($taxesTotal)
->setInvoiceTaxSubTotal($taxSubtotal)
->setInvoiceAllowanceCharges($allowanceCharge)
->setInvoiceLines(...$invoiceLines)
->setCertificateEncoded($vatENV['productionCertificate'])
->setPrivateKeyEncoded($vatENV['privateKey'])
->setCertificateSecret($vatENV['productionCertificateSecret'])
->sendDocument(true);
// var_dump($response);
// exit();
// saving data to zatca_documents
$ms_response = $response["response"] ;

$stringResponse = json_encode($ms_response, JSON_PRETTY_PRINT);
echo("<hr/>");
echo "sucess ".$response['success'];

if($response['success']){
    
    //   echo"<br /> has <br /> ";
//   echo($response['hash']);
//   echo"<br /> xml <br /> ";
//   echo($response['xml']);
//   echo"<br /> wsigning_time <br /> ";
//   echo($response['signing_time']);
//   echo"<br /> qr_valu <br /> ";
//   echo($response['qr_value']);
//   echo($response['response']->validationResults->warningMessages[0]->message);
//   echo("<br />");
//   echo($response['response']->validationResults->warningMessages[0]->code);
//   echo("<br />");
   
      echo"<br /> wreportingStatus <br /> ";
    echo($response['response']->{$message_key});
    $sent_to_zatca_status = $response['response']->{$message_key};

    $hash = $response['hash'];
    $xml = $response['xml'];
    $qr_value = $response['qr_value'] ;
//
        $dateTime = new DateTime($response['signing_time']);
        $signing_time = $dateTime->format('Y-m-d H:i:s');
        $sent_to_zatca = 1 ;
if (($sent_to_zatca_status == "REPORTED")||($sent_to_zatca_status == "CLEARED" )){
    $sent_to_zatca = 1 ;
    }else{
        $sent_to_zatca = 0 ;
    }
    
    $sql = $conn->prepare("UPDATE zatca_documents SET hash = ? , xml = ? ,sent_to_zatca = ?  , sent_to_zatca_status = ? , signing_time = ? , response = ? , qr_value = ?
                            WHERE icv = ?");

    $sql->bindParam(1,$hash);
    $sql->bindParam(2, $xml);
    $sql->bindParam(3, $sent_to_zatca);
    $sql->bindParam(4,$sent_to_zatca_status);
    $sql->bindParam(5,$signing_time);
    $sql->bindParam(6,$stringResponse);
    $sql->bindParam(7,$qr_value);
    $sql->bindParam(8,$icv);
    $sql->execute();
}else{
echo "faill";
var_dump($response);
}

$writer = new PngWriter();

$qrCode = new QrCode(
    data: $response['qr_value'],
    encoding: new Encoding('UTF-8'),
    errorCorrectionLevel: ErrorCorrectionLevel::Low,
    size: 300,
    margin: 10,
    roundBlockSizeMode: RoundBlockSizeMode::Margin,
    foregroundColor: new Color(0, 0, 0),
    backgroundColor: new Color(255, 255, 255)
);

$result = $writer->write($qrCode);
echo " <img src='".$result->getDataUri()."'> ";

