<?php
include "./vendor/autoload.php";
    use Allam\Zatca\OnBoarding;
    $response = (new OnBoarding())
    ->setZatcaEnv('simulation')
    ->setZatcaLang('en')
    ->setEmailAddress('email@gmail.com')
    ->setCommonName('TSTCO')
    ->setCountryCode('SA')
    ->setOrganizationUnitName('TSTCO-SA')
    ->setOrganizationName('TSTCO-SA')
    ->setEgsSerialNumber('1-MOH|2-SIM|3-772206')
    ->setVatNumber('310460038300003')
    ->setInvoiceType('1100')
    ->setRegisteredAddress('SAUDI')
    ->setAuthOtp('772206')
    ->setBusinessCategory('Transportations')
    ->getAuthorization();
    var_dump($response);

    use Allam\Zatca\Invoice\Client;
    use Allam\Zatca\Invoice\Supplier;
    use Allam\Zatca\Invoice\Delivery;
    use Allam\Zatca\Invoice\PaymentType;
    use Allam\Zatca\Invoice\PIH;
    use Allam\Zatca\Invoice\ReturnReason;
    use Allam\Zatca\Invoice\BillingReference;
    use Allam\Zatca\Invoice\AdditionalDocumentReference;
    use Allam\Zatca\Invoice\LegalMonetaryTotal;
    use Allam\Zatca\Invoice\TaxesTotal;
    use Allam\Zatca\Invoice\TaxSubtotal;
    use Allam\Zatca\Invoice\LineTaxCategory;
    use Allam\Zatca\Invoice\InvoiceLine;
    use Allam\Zatca\Invoice\AllowanceCharge;
    use Allam\Zatca\Invoice\InvoiceGenerator;

    $client = (new Client())
    ->setVatNumber('300000000000003')
    ->setStreetName('STREET')
    ->setBuildingNumber('1111')
    ->setPlotIdentification('2223')
    ->setSubDivisionName('JEDDAH')
    ->setCityName('JEDDAH')
    ->setPostalNumber('12222')
    ->setCountryName('SA')
    ->setClientName('TSTCO');

    $supplier = (new Supplier())
    ->setCrn('1000000000')
    ->setStreetName('RIYADH')
    ->setBuildingNumber('2322')
    ->setPlotIdentification('2223')
    ->setSubDivisionName('RIYADH')
    ->setCityName('RIYADH')
    ->setPostalNumber('11633')
    ->setCountryName('SA')
    ->setVatNumber('310460038300003')
    ->setVatName('TSTCO');

    $delivery = (new Delivery())
    ->setDeliveryDateTime('2022-09-07');

    $paymentType = (new PaymentType())
    ->setPaymentType('10');

    $returnReason = (new ReturnReason())
    ->setReturnReason('SET_RETURN_REASON');

    $previous_hash = (new PIH())
    ->setPIH('X+zrZv/IbzjZUnhsbWlsecLbwjndTpG0ZynXOif7V+k=');  // note this value it from step 3 , 4

    $billingReference = (new BillingReference())
    ->setBillingReference('23'); // note this used when type credit or debit this value of parent invoice id

    $additionalDocumentReference = (new AdditionalDocumentReference())
    ->setInvoiceID('55'); // note this value it from step 1

    $legalMonetaryTotal = (new LegalMonetaryTotal())
    ->setTotalCurrency('SAR')
    ->setLineExtensionAmount(4)
    ->setTaxExclusiveAmount(2)
    ->setTaxInclusiveAmount(2.30)
    ->setAllowanceTotalAmount(2)
    ->setPrepaidAmount(0)
    ->setPayableAmount(2.30);

    $taxesTotal = (new TaxesTotal())
    ->setTaxCurrencyCode('SAR')
    ->setTaxTotal(0.30);

    $taxSubtotal = (new TaxSubtotal())
    ->setTaxCurrencyCode('SAR')
    ->setTaxableAmount(2.00)
    ->setTaxAmount(0.30)
    ->setTaxCategory('S')
    ->setTaxPercentage(15)
    ->getElement();

    $itemTaxCategory = (new LineTaxCategory())
    ->setTaxCategory('S')
    ->setTaxPercentage(15)
    ->getElement();

    $invoiceLines[] = (new InvoiceLine())
    ->setLineID('1')
    ->setLineName('TST Item')
    ->setLineCurrency('SAR')
    ->setLinePrice(2)
    ->setLineQuantity(2)
    ->setLineSubTotal(4)
    ->setLineTaxTotal(0.60)
    ->setLineNetTotal(4.60)
    ->setLineTaxCategories($itemTaxCategory)
    ->setLineDiscountReason('reason')
    ->setLineDiscountAmount(2)
    ->getElement();

    $allowanceCharge = (new AllowanceCharge())
    ->setAllowanceChargeCurrency('SAR')
    ->setAllowanceChargeIndex('1')
    ->setAllowanceChargeAmount(2)
    ->setAllowanceChargeTaxCategory('S')
    ->setAllowanceChargeTaxPercentage(15)
    ->getElement();

    $response = (new InvoiceGenerator())
    ->setZatcaEnv('simulation')
    ->setZatcaLang('en')
    ->setInvoiceNumber('SME00023')
    ->setInvoiceUuid('8d487816-70b8-4ade-a618-9d620b73814a') // this value from step 6
    ->setInvoiceIssueDate('2022-09-07')
    ->setInvoiceIssueTime('12:21:28')
    ->setInvoiceType('0100000','388')
    ->setInvoiceCurrencyCode('SAR')
    ->setInvoiceTaxCurrencyCode('SAR')
    //->setInvoiceBillingReference($billingReference)  use this when document type is credit or debit
    ->setInvoiceAdditionalDocumentReference($additionalDocumentReference)
    ->setInvoicePIH($previous_hash)
    ->setInvoiceSupplier($supplier)
    ->setInvoiceClient($client)
    ->setInvoiceDelivery($delivery)
    ->setInvoicePaymentType($paymentType)
    //->setInvoiceReturnReason($returnReason) use this when document type is credit or debit
    ->setInvoiceLegalMonetaryTotal($legalMonetaryTotal)
    ->setInvoiceTaxesTotal($taxesTotal)
    ->setInvoiceTaxSubTotal($taxSubtotal)
    ->setInvoiceAllowanceCharges($allowanceCharge)
    ->setInvoiceLines(...$invoiceLines)
    ->setCertificateEncoded("TUlJRDJUQ0NBMytnQXdJQkFnSVRZd0FBS2JRTzhFVEpJSlNhQ2dBQkFBQXB0REFLQmdncWhrak9QUVFEQWpCaU1SVXdFd1lLQ1pJbWlaUHlMR1FCR1JZRmJHOWpZV3d4RXpBUkJnb0praWFKay9Jc1pBRVpGZ05uYjNZeEZ6QVZCZ29Ka2lhSmsvSXNaQUVaRmdkbGVIUm5ZWHAwTVJzd0dRWURWUVFERXhKUVJWcEZTVTVXVDBsRFJWTkRRVEV0UTBFd0hoY05NalF3TnpFNE1URTFPVFV3V2hjTk1qWXdOekU0TVRJd09UVXdXakJETVFzd0NRWURWUVFHRXdKVFFURVJNQThHQTFVRUNoTUlWRk5VUTA4dFUwRXhFVEFQQmdOVkJBc1RDRlJUVkVOUExWTkJNUTR3REFZRFZRUURFd1ZVVTFSRFR6QldNQkFHQnlxR1NNNDlBZ0VHQlN1QkJBQUtBMElBQklxT2d3ZkJKTWljVWJqVUE4MWpyblBTL2U3TmVUbFJVcThTTGxFOVZBY3Z4RnBuRFg3N05LWlBqZ29aNGFnMjRpWm1OOW10QjZkRkY1b0dONG9GaWVpamdnSTBNSUlDTURDQmhnWURWUjBSQkg4d2ZhUjdNSGt4SFRBYkJnTlZCQVFNRkRFdFRVOUlmREl0VTBsTmZETXROemN5TWpBMk1SOHdIUVlLQ1pJbWlaUHlMR1FCQVF3UE16RXdORFl3TURNNE16QXdNREF6TVEwd0N3WURWUVFNREFReE1UQXdNUTR3REFZRFZRUWFEQVZUUVZWRVNURVlNQllHQTFVRUR3d1BWSEpoYm5Od2IzSjBZWFJwYjI1ek1CMEdBMVVkRGdRV0JCUU5BQmR1L0JpYlkyTXFiWjZrdktxYUZNU0Y5akFmQmdOVkhTTUVHREFXZ0JTcVdEaURxWllsVGVwVWVybVVCK05YVVBnNzZEQ0J6Z1lJS3dZQkJRVUhBUUVFZ2NFd2diNHdnYnNHQ0NzR0FRVUZCekFDaG9HdWJHUmhjRG92THk5RFRqMVFSVnBGU1U1V1QwbERSVk5EUVRFdFEwRXNRMDQ5UVVsQkxFTk9QVkIxWW14cFl5VXlNRXRsZVNVeU1GTmxjblpwWTJWekxFTk9QVk5sY25acFkyVnpMRU5PUFVOdmJtWnBaM1Z5WVhScGIyNHNSRU05WlhoMGVtRjBZMkVzUkVNOVoyOTJMRVJEUFd4dlkyRnNQMk5CUTJWeWRHbG1hV05oZEdVL1ltRnpaVDl2WW1wbFkzUkRiR0Z6Y3oxalpYSjBhV1pwWTJGMGFXOXVRWFYwYUc5eWFYUjVNQTRHQTFVZER3RUIvd1FFQXdJSGdEQThCZ2tyQmdFRUFZSTNGUWNFTHpBdEJpVXJCZ0VFQVlJM0ZRaUJocWdkaE5EN0VvYnRuU1NIenZzWjA4QlZab0djMkMyRDVjVmRBZ0ZrQWdFUU1CMEdBMVVkSlFRV01CUUdDQ3NHQVFVRkJ3TUNCZ2dyQmdFRkJRY0RBekFuQmdrckJnRUVBWUkzRlFvRUdqQVlNQW9HQ0NzR0FRVUZCd01DTUFvR0NDc0dBUVVGQndNRE1Bb0dDQ3FHU000OUJBTUNBMGdBTUVVQ0lRRHBPSmk1akVCMTJzcWFkZFN5OXF1eDhUNHA2MzJLQmk5di9SeFB2Q1N2V2dJZ0dldFNXczhjYU9HenVIb3JUV1VjR3Vxc1BRTnEyRXJ1VmlxdzNFQXlMOVE9")
    ->setPrivateKeyEncoded("LS0tLS1CRUdJTiBQUklWQVRFIEtFWS0tLS0tCk1JR0VBZ0VBTUJBR0J5cUdTTTQ5QWdFR0JTdUJCQUFLQkcwd2F3SUJBUVFnSGpGdjJORzUxWXU4Q2JOa3phaFoKSmlTV0VuY215SlQ0elk1Y0w4WUV0OEtoUkFOQ0FBU0tqb01Id1NUSW5GRzQxQVBOWTY1ejB2M3V6WGs1VVZLdgpFaTVSUFZRSEw4UmFadzErK3pTbVQ0NEtHZUdvTnVJbVpqZlpyUWVuUlJlYUJqZUtCWW5vCi0tLS0tRU5EIFBSSVZBVEUgS0VZLS0tLS0K")
    ->setCertificateSecret("gpsJnCQyDe+bFZWaZ/DKj69OB5YPHTUpFJJWVNhWVzo=")
    ->sendDocument(true);
    var_dump($response);