<?php
namespace Allam\Zatca;
use Allam\Zatca\VatBase ;
session_start( [ 
  'name' => 'PHPSESSID',
  'sid_length' => 128,
  'sid_bits_per_character' => 6,
  'use_strict_mode' => true,
  'referer_check' => $_SERVER['HTTP_HOST'],
  ]);
  // session_set_cookie_params(
  //   $currentCookieParams["secure"],
  //   $currentCookieParams["httponly"]
  // );
ob_start();


require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/send_email.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

function generateToken() {
    return bin2hex(random_bytes(32));
}

function updateToken($userId, $conn):string {
    $token = generateToken();
    $expiry = date('Y-m-d H:i:s', strtotime('+45 minutes'));
    $api_key = bin2hex(random_bytes(9)); 
    $stmt = $conn->prepare("UPDATE users SET refresh_token = ?, token_expiry = ? ,api_key = ? WHERE id = ?");
    $stmt->execute([$token, $expiry, $api_key , $userId ]);
    
    $_SESSION['token'] = $token;
    $_SESSION['token_expiry'] = $expiry;
    
    return $api_key ;
}

function checkLockout($username, $conn) {
    $stmt = $conn->prepare("SELECT login_attempts, locked_until FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && $user['locked_until'] !== null) {
        if (strtotime($user['locked_until']) > time()) {
            return false; // Still locked
        } else {
            // Reset lockout if time has passed
            $stmt = $conn->prepare("UPDATE users SET login_attempts = 0, locked_until = NULL WHERE username = ?");
            $stmt->execute([$username]);
        }
    }
    return true;
}

function incrementLoginAttempts($username, $conn) {
    $stmt = $conn->prepare("UPDATE users SET login_attempts = login_attempts + 1 WHERE username = ?");
    $stmt->execute([$username]);

    $stmt = $conn->prepare("SELECT login_attempts FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $attempts = $stmt->fetchColumn();

    if ($attempts >= 2) {
        $lockUntil = date('Y-m-d H:i:s', strtotime('+180 minutes'));
        $stmt = $conn->prepare("UPDATE users SET locked_until = ? WHERE username = ?");
        $stmt->execute([$lockUntil, $username]);
        
        // Send email notification
        // sendLockoutEmail($username);
        return false;
    }
    return true;
}

function resetLoginAttempts($username, $conn) {
    $stmt = $conn->prepare("UPDATE users SET login_attempts = 0, locked_until = NULL WHERE username = ?");
    $stmt->execute([$username]);
}

if(isset($_POST['login_credentials'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    if (!checkLockout($username, $conn)) {
        header("Location: index.php?error=locked");
        exit();
    }

    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    
    $email = $user['email'];
    
    if($user && password_verify($password, $user['password'])) {
        resetLoginAttempts($username, $conn);
        // $_SESSION['user_id'] = $user['id'];
        $api_key = updateToken($user['id'], $conn);
         sendEmail($email , $api_key);
        // header("Location: dashboard.php");
        header("Location: index.php");
        
        exit();
    } else {
        if (!incrementLoginAttempts($username, $conn)) {
            header("Location: index.php?error=locked");
            exit();
        }
        header("Location: index.php?error=invalid");
        exit();
    }
}

elseif(isset($_POST['login_apikey'])) {
    $apikey = $_POST['apikey'];
    
    $stmt = $conn->prepare("SELECT * FROM users WHERE api_key = ?");
    $stmt->execute([$apikey]);
    $user = $stmt->fetch();
    
    if($user) {
        $_SESSION['user_id'] = $user['id'];
        // updateToken($user['id'], $pdo);
        header("Location: dashboard.php");
        exit();
    }
}

header("Location: index.php?error=1");
exit();