<?php
namespace Allam\Zatca;
session_start();

use Allam\Zatca\VatBase ;

require_once __DIR__ . '/../src/VatBase.php';
$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Check token expiry
if(isset($_SESSION['token_expiry']) && strtotime($_SESSION['token_expiry']) < time()) {
    session_destroy();
    header("Location: index.php?expired=1");
    exit();
}

// Update token on any action
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم</title>
    <link rel="stylesheet" href="dist/css/bootstrap.rtl.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="custom/style.css">
    <link rel="icon" href="../custom/perfect.ico">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
    </style>
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">لوحة التحكم</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="logout.php">تسجيل الخروج</a>
            </div>
        </div>
    </nav>

    <div class="toast-container position-fixed top-50 start-50 translate-middle">
        <div id="actionToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-body fs-5"></div>
        </div>
    </div>
    <div class="container-fluid h-100 pt-4 d-flex flex-column">
        <div class="row flex-grow-1"></div>
        <div class="row mb-4">
            <div class="col-md-6 p-1">
                <button id="import_btn" class="btn btn-primary dashboard-btn w-100 h-80"> استيراد فواتير</button>
            </div>
            <div class="col-md-6 p-1">
                <button id="invoices_btn" class="btn btn-success dashboard-btn w-100 h-80">فواتير</button>
            </div>
            <div class="col-md-6 p-1">
                <button id="send_btn" class="btn btn-secondary dashboard-btn w-100 h-80">تصدير الي هيئة الزكاة</button>
            </div>
            <div class="col-md-6 p-1">
                <button class="btn btn-outline-info dashboard-btn w-100 h-80" onclick="handleStats()">احصائيات</button>
            </div>
        </div>
    </div>
    
    <script src="dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function checkSession() {
            fetch('check_session.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.valid) {
                        window.location.href = 'index.php?expired=1';
                    }
                });
        }

        // Check every 60 seconds
        setInterval(checkSession, 60000);
    </script>
    <script src="custom/sc.js"></script>
</body>
</html>