<?php
// namespace Allam\Zatca;
session_start();

use Allam\Zatca\SendDebit;
use Allam\Zatca\VatBase ;
// use Allam\Zatca\SendToZatca ;

require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/SendDebit.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+35 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $invoice_id = $_POST['invoice_id'];
    $response['success'] = false;

    if (!empty($invoice_id)) {

        $zatca = new SendDebit();

        $vatENV = $zatca->vatENV();

        $dbSupplier = $zatca->dbSupplier();
        $debit = $zatca->debit($invoice_id);

        $nany = $zatca->saveDocument($invoice_id, $vatENV, $dbSupplier,$debit);
            $company = $person =  0;
        if($nany =="CLEARED"){
                $company++;
            }elseif($nany =="REPORTED"){
                $person++ ;
            }
        $response['success'] = true;
        $response['msg'] = "تم تصدير عدد $person  إشعار خصم أفراد و عدد $company إشعار خصم شركات";
            } else {
        $response['success'] = false;
        $response['msg'] = 'يوجد خطأ في التصدير';
    }
    header('Content-Type: application/json');
    echo json_encode($response);
}

?>