<?php
// namespace Allam\Zatca;
session_start();

use Allam\Zatca\VatBase ;
use Allam\Zatca\PreVat ;

require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/PreVat.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mydate = $_POST['mydate'];
    $response['success'] = false;
    if (!empty($mydate)) {

        $pre = new PreVat();
        $father = ($_SESSION['user_id']);
        $mydate = date("Y-m-d H:i:s"); 
        $nany = $pre->createVat($father);
        // $nany = $pre->vatData($mydate);
        $response['success'] = true;
        $response['msg'] = $nany;
    }else{
        $response['success'] = false;
        $response['msg'] = 'فضلا اختار التاريخ';
    }
    header('Content-Type: application/json');
    echo json_encode($response);
}
//
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $itemId = isset($data['id']) ? trim($data['id']) : null;

    if ($itemId && ctype_digit($itemId)) {
        // Simulate successful deletion (replace with real DB logic)
        $pre = new PreVat();
        $response = $pre->deleteVat($itemId);
        echo json_encode([
            'success' => true,
            'msg' => $response
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'msg' => 'Invalid item ID provided.'
        ]);
    }
} ;
// else {
//     echo json_encode([
//         'success' => false,
//         'msg' => 'Invalid request method: ' . $_SERVER['REQUEST_METHOD']
//     ]);
// }
?>