<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام الوسام</title>
    <!-- Bootstrap RTL CSS -->
    <link rel="stylesheet" href="dist/css/bootstrap.rtl.min.css">
    <!-- Custom Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
        
        .splash-screen {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #1a1f23;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s;
        }

        .splash-logo {
            width: 200px;
            margin-bottom: 20px;
            animation: fadeIn 1.5s ease-in;
        }

        .splash-text {
            color: #39c790;
            font-size: 27px;
            margin-top: 10px;
            animation: fadeIn 1.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .main-content {
            display: none;
        }
    </style>
</head>

<body class="bg-light">
    <!-- Add Splash Screen -->
    <div class="splash-screen">
        <img src="assets/welcome.png" alt="الوسام" class="splash-logo">
        <div class="splash-text">الوسام المعتمد لتأجير السيارات</div>
        <div class="splash-text" style="font-size: 21px; color: #2a9d8f;">الوسام المعتمد 2026</div>
    </div>

    <!-- Wrap existing content in main-content div -->
    <div class="main-content">
        <div class="container mt-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <ul class="nav nav-tabs card-header-tabs">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#credentials">تسجيل الدخول بالحساب</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#apikey">دخول بمفتاح API</a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <?php if (isset($_GET['error'])): ?>
                                <div class="alert alert-danger">
                                    <?php
                                    if ($_GET['error'] == 'locked') {
                                        echo 'الحساب مقفل لمدة 30 دقيقة بسبب محاولات تسجيل دخول متكررة';
                                    } elseif ($_GET['error'] == 'invalid') {
                                        echo 'اسم المستخدم أو كلمة المرور غير صحيحة';
                                    }
                                    ?>
                                </div>
                            <?php endif; ?>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="credentials">
                                    <form action="auth.php" method="POST">
                                        <div class="mb-3">
                                            <label for="username" class="form-label">اسم المستخدم</label>
                                            <input type="text" class="form-control" id="username" name="username" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="password" class="form-label">كلمة المرور</label>
                                            <input type="password" class="form-control" id="password" name="password" required>
                                        </div>
                                        <button type="submit" class="btn btn-primary" name="login_credentials">تسجيل الدخول</button>
                                    </form>
                                </div>
                                <div class="tab-pane fade" id="apikey">
                                    <form action="auth.php" method="POST">
                                        <div class="mb-3">
                                            <label for="apikey" class="form-label">مفتاح API</label>
                                            <input type="text" class="form-control" id="apikey" name="apikey" required>
                                        </div>
                                        <button type="submit" class="btn btn-primary" name="login_apikey">تسجيل الدخول</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </body>
    <script src="dist/js/bootstrap.bundle.min.js"></script>
    <!-- Add this before closing body tag -->
    <script>
        window.addEventListener('load', function() {
            setTimeout(function() {
                document.querySelector('.splash-screen').style.opacity = '0';
                document.querySelector('.main-content').style.display = 'block';
                setTimeout(function() {
                    document.querySelector('.splash-screen').remove();
                }, 750);
            }, 3000);
        });

    </script>


</html>