<?php
namespace Allam\Zatca;
session_start();
if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
use Allam\Zatca\DataBase ;

require_once __DIR__ . '/../onboarding_example.php';
// use Allam\Zatca\DataBase ;

require_once __DIR__ . '/../src/VatBase.php';
$vatbase = new VatBase();

$conn = $vatbase->getConnection();



// Check token expiry
if(isset($_SESSION['token_expiry']) && strtotime($_SESSION['token_expiry']) < time()) {
    session_destroy();
    header("Location: index.php?expired=1");
    exit();
}

// Update token on any action
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}
?>
<script>
        function checkSession() {
            fetch('check_session.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.valid) {
                        window.location.href = 'index.php?expired=1';
                    }
                });
        }

        // Check every 60 seconds
        setInterval(checkSession, 90000);
    </script>
