<?php
// namespace Allam\Zatca;
session_start();

use Allam\Zatca\VatBase ;
use Allam\Zatca\SendToZatca ;

require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/SendToZatca.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+35 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mydate = $_POST['mydate'];
    $response['success'] = false;
    if (!empty($mydate)) {

        $zatca = new SendToZatca();

        $vatENV = $zatca->vatENV();

        $dbSupplier = $zatca->dbSupplier();
//

$sql = "SELECT `IRN` ,`contract_id`,`VatNumber`,`ClientName`,`TaxableAmount`,`TaxAmount` ,`PayableAmount`,`InvoiceIssueDate`
                    FROM `prevat`
                    WHERE MONTH(`InvoiceIssueDate`) = MONTH(CURRENT_DATE())
                    AND `IRN` NOT IN (
                            SELECT invoice_id from zatca_documents 
                            WHERE sent_to_zatca_status IN('CLEARED','REPORTED') 
                            AND MONTH(signing_time) = MONTH(CURRENT_DATE()))";
             $stmt = $conn->prepare($sql);
             $stmt->execute();
             if($stmt->rowCount() > 0){
                $person = 0 ;
                $company = 0;
                while ($row = $stmt->fetch()){
                    $invoice_id = $row['IRN'];
                    $nany = $zatca->saveDocument($invoice_id, $vatENV, $dbSupplier);
                    
                    if($nany =="CLEARED"){
                        $company++;
                    }elseif($nany =="REPORTED"){
                        $person++ ;
                    }
                }
                $response['success'] = true;
        $response['msg'] = "تم تصدير عدد $person  فاتورة أفراد و عدد $company فاتورة شركات";
            } else {
        $response['success'] = false;
        $response['msg'] = 'يوجد خطأ في التصدير';
    }
    header('Content-Type: application/json');
    echo json_encode($response);
}}
?>