<?php
// namespace Allam\Zatca;
session_start();

use Allam\Zatca\VatBase ;
use Allam\Zatca\SendToZatca ;

require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/SendToZatca.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+15 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mydate = $_POST['mydate'];
    $response['success'] = false;
    if (!empty($mydate)) {

        $zatca = new SendToZatca();

        $vatENV = $zatca->vatENV();

        $dbSupplier = $zatca->dbSupplier();

        $invoice_id = 26146;
        

        $nany = $zatca->saveDocument($invoice_id, $vatENV, $dbSupplier);
        $response['success'] = true;
        $response['msg'] = $nany;
    } else {
        $response['success'] = false;
        $response['msg'] = 'فضلا اختار التاريخ';
    }
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>