<?php
// namespace Allam\Zatca;
session_start();

use Allam\Zatca\VatBase ;
use Allam\Zatca\MainBase ;
use Allam\Zatca\PreVat ;

require_once __DIR__ . '/../src/VatBase.php';
require_once __DIR__ . '/../src/MainBase.php';
require_once __DIR__ . '/../src/PreVat.php';

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

$main = new MainBase();
$mainBase = $main->getConnection();

if(!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
if(isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+35 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

// if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    function oldVat($conn ,$first_day ,$last_day):array
    {
        $oldVAT = [] ;
        $pre = $conn->prepare("SELECT IRN from prevat where DeliveryDateTime BETWEEN ? AND ?");
        $pre->bindParam(1, $first_day);
        $pre->bindParam(2, $last_day);
        $pre->execute();
        while ($row = $pre->fetch()) {
            $oldVAT[] = $row['IRN'];
        }
        // $oldPreVAT ="1";
        // if(!empty($oldVAT)){
        //     $oldPreVAT = implode(',', $oldVAT);
        // }  
        return $oldVAT ;    
    }
    // $mydate = $_POST['mydate'];
    // $response['success'] = false;
    // if (!empty($mydate)) {

        $pre = new PreVat();
        $father = ($_SESSION['user_id']);
        $myday = date("Y-m-d H:i:s"); 

        $first_day  = date('Y-m-01', strtotime($myday));
        $last_day 	= date('Y-m-t', strtotime($myday));
    header('Content-Type: application/json');
    $oldPreVAT = oldVat($conn ,$first_day ,$last_day);

    $sql = $mainBase->prepare("SELECT * from vat where duedate BETWEEN ? AND ? ");
        $sql->bindParam(1, $first_day);
        $sql->bindParam(2, $last_day);
        $sql->execute();
    if ($sql->rowCount() > 0) {
        $new = [];
        while ($row = $sql->fetch()) {
            $vat_id = $row['vat_id'];
            if (in_array($vat_id, $oldPreVAT)) continue;
            $new[] = $vat_id;
        }
    }
//

    echo json_encode($pre->vatData($myday));
// }
?>