<?php

namespace Allam\Zatca;

session_start();

use Allam\Zatca\VatBase;

require_once __DIR__ . '/../../src/VatBase.php';
$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Check token expiry
if (isset($_SESSION['token_expiry']) && strtotime($_SESSION['token_expiry']) < time()) {
    session_destroy();
    header("Location: ../index.php?expired=1");
    exit();
}

// Update token on any action
if (isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+35 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الفواتير الجديدة</title>
    <link href="../dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../custom/myCar.css" />
    <!-- <link rel="stylesheet" href="../custom/style.css"> -->
    <link rel="icon" href="../custom/perfect.ico">
    <style>
        .toast {
            background-color: rgba(255, 255, 255, 0.95);
            min-width: 200px;
            text-align: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-radius: 8px;
        }

        .toast-body {
            font-size: 1.2rem;
            padding: 1.5rem;
        }
    </style>
</head>

<body style="background-color: #00324d;">
    <div class="toast-container position-fixed top-50 start-50 translate-middle">
        <div id="actionToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-body fs-5" style="background-color: #cce5ff;"></div>
        </div>
    </div>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-8 mb-3">
                <h3 style="color: #cce5ff;">فواتير ما قبل الإرسال لمنصة فاتورة</h3>
            </div>
            <div class="col-md-2 mb-3"></div>
            <div class="col-md-2 mb-3">
                <button type="submit" id="getNew_btn" class="btn btn-success"> إستيراد فواتير جديدة</button>
            </div>
        </div>
        <div class="mb-3">
            <input type="text" id="searchInput" class="form-control" placeholder="بحث...">
        </div>
        <!-- table-striped -->
        <div class="panel-body" style="background-color:#00324d ; color:#cce5ff;">
            <!-- <div class="table-responsive"> -->
            <table class="table table-responsive table-bordered table-hover" id="newInvoiceTable">
                <thead class="sticky-top top-0">
                    <tr class="table-info">
                        <th class="text-center" width="4%">م</th>
                        <th>رقم الفاتورة</th>
                        <th>اسم العميل</th>
                        <th>مبلغ الفاتورة</th>
                        <th>الضريبة</th>
                        <th>شامل الضريبة</th>
                        <th>تاريخ الإصدار </th>
                        <th>رقم العقد</th>
                        <th>حذف</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sql = "SELECT `IRN` ,`contract_id`,`VatNumber`,`ClientName`,`TaxableAmount`,`TaxAmount` ,`PayableAmount`,`InvoiceIssueDate`
                    FROM `prevat`
                    WHERE MONTH(`InvoiceIssueDate`) = MONTH(CURRENT_DATE())
                    AND `IRN` NOT IN (
                            SELECT invoice_id from zatca_documents 
                            WHERE sent_to_zatca_status IN('CLEARED','REPORTED') 
                            AND MONTH(signing_time) = MONTH(CURRENT_DATE())
                        ) ";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute();
                    if ($stmt->rowCount() > 0) {
                        $nn = 1;
                        while ($preInvoice = $stmt->fetch()) {
                            $style = "";
                            $VatNumber = (int) $preInvoice['VatNumber'];
                            if (!empty($VatNumber)) {
                                $style = "background-color: green;";
                            }
                            $IRN = $preInvoice["IRN"];
                            $rows = null;
                            $rows = "<tr>";
                            $rows .= "<td>" . $nn . "</td>";
                            $rows .= "<td>" . $IRN . "</td>";
                            $rows .= "<td>" . $preInvoice["ClientName"] . "</td>";
                            $rows .= "<td>" . $preInvoice["TaxableAmount"] . "</td>";
                            $rows .= "<td>" . $preInvoice["TaxAmount"] . "</td>";
                            $rows .= "<td>" . $preInvoice["PayableAmount"] . "</td>";
                            $rows .= "<td>" . $preInvoice["InvoiceIssueDate"] . "</td>";
                            $rows .= "<td style='$style' >"  . $preInvoice["contract_id"] . "</td>";
                            $rows .= "<td style='padding:0px;margin:0px;'><button id='$IRN' style='font-weight:bold ;font-size:14px; padding:2;' class='btn btn-danger btn-ms btn-block IRN_delete '>حذف</button></td>";
                            $rows .= "</tr>";
                            echo $rows;
                            $nn = 1 + $nn;
                        }
                    } else {
                        echo "<tr><td colspan='9'>لا توجد فواتير جديدة</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
            <br/>
            <div class="row">
            <div class="col-md-8 mb-3">
                <h3 style="color: #cce5ff;">تصدير فواتير إلي منصة فاتورة</h3>
            </div>
            <div class="col-md-2 mb-3"></div>
            <div class="col-md-2 mb-3">
                <button type="submit" id="send_btn" class="btn btn-success">تصدير فواتير</button>
            </div>
        </div>
        </div>
    </div>

    <script src="../dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const table = document.getElementById('newInvoiceTable');
            const rows = table.getElementsByTagName('tr');

            searchInput.addEventListener('input', function() {
                const searchTerm = searchInput.value.toLowerCase();

                for (let i = 1; i < rows.length; i++) {
                    let row = rows[i];
                    let text = row.textContent.toLowerCase();

                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                }
            });
        });

        function showToast(message) {
            const toastElement = document.getElementById('actionToast');
            const toast = new bootstrap.Toast(toastElement);
            toastElement.querySelector('.toast-body').textContent = message;
            toast.show();
        }
        document.getElementById('getNew_btn').addEventListener('click', async (e) => {
            e.preventDefault();
            const mydate = new Date();
            const formData = new FormData();

            formData.append('mydate', mydate);

            try {
                const response = await fetch('../import.php', {
                    method: 'POST',
                    body: formData,
                });
                const result = await response.json();
                if (result.success) {
                    // alert(result.save_msg);
                    showToast(result.msg);
                    location.reload();
                } else {
                    showToast(result.msg);
                }
            } catch (error) {
                console.error('Error:', error);
                alert('An error occurred ' + error);
            }
        });
        //
        document.getElementById('send_btn').addEventListener('click', async (e) => {
            e.preventDefault();
            const mydate = new Date();
            const formData = new FormData();

            formData.append('mydate', mydate);

            try {
                const response = await fetch('../sendControler.php', {
                    method: 'POST',
                    body: formData,
                });
                const result = await response.json();
                if (result.success) {
                    // alert(result.save_msg);
                    showToast(result.msg);
                    location.reload();
                } else {
                    showToast(result.msg);
                }
            } catch (error) {
                console.error('Error:', error);
                alert('An error occurred' + error);
            }
        });

document.querySelectorAll('.IRN_delete').forEach(button => {
    button.addEventListener('click', async (e) => {
        e.preventDefault();
        // Get item ID from data attribute
        var id = e.currentTarget.id;
        if (!id) {
            alert("فضلا اختار الفاتورة اولا");
            return;
        }

        try {
            const response = await fetch('../import.php', {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ id: id })
            });

            const result = await response.json();

            if (result.success) {
                showToast(result.msg); // Or handle success
                location.reload();
            } else {
                showToast(result.msg || "Failed to delete.");
            }

        } catch (error) {
            console.error('Error:', error);
            alert('An error occurred: ' + error.message);
        }
    });
});
    </script>
     <script>
        function checkSession() {
            fetch('../check_session.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.valid) {
                        window.location.href = '../index.php?expired=1';
                    }
                });
        }

        // Check every 60 seconds
        setInterval(checkSession, 60000);
    </script>
    <?php
    ob_end_flush();
    ?>
</body>

</html>