<?php
namespace Allam\Zatca;

session_start();

use Allam\Zatca\VatBase;

require_once __DIR__ . '/../../src/VatBase.php';
$vatbase = new VatBase();

$conn = $vatbase->getConnection();

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Check token expiry
if (isset($_SESSION['token_expiry']) && strtotime($_SESSION['token_expiry']) < time()) {
    session_destroy();
    header("Location: ../index.php?expired=1");
    exit();
}

// Update token on any action
if (isset($_SESSION['user_id'])) {
    $stmt = $conn->prepare("UPDATE users SET token_expiry = ? WHERE id = ?");
    $newExpiry = date('Y-m-d H:i:s', strtotime('+35 minutes'));
    $stmt->execute([$newExpiry, $_SESSION['user_id']]);
    $_SESSION['token_expiry'] = $newExpiry;
}
$response = [];

$sql = "SELECT prevat.IRN ,prevat.contract_id, prevat.VatNumber,prevat.ClientName,prevat.TaxableAmount,prevat.TaxAmount ,  prevat.PayableAmount,prevat.InvoiceIssueDate , zatca_documents.sent_to_zatca_status
                    FROM `prevat` , zatca_documents 
                    WHERE prevat.IRN = zatca_documents.invoice_id
                    AND MONTH(`InvoiceIssueDate`) = MONTH(CURRENT_DATE())
                    AND  sent_to_zatca_status IN('CLEARED','REPORTED')
                    ORDER BY IRN DESC
                    LIMIT 150";
$stmt = $conn->prepare($sql);
$stmt->execute();
if ($stmt->rowCount() > 0) {
    $nn = 1;
    while ($preInvoice = $stmt->fetch()) {
        $style = "";
        $VatNumber = (int) $preInvoice['VatNumber'];
        $IRN = $preInvoice["IRN"];
        if (!empty($VatNumber)) {
            $style = "background-color: green;";
        }
        $rows = null;
        $rows = "<tr>";
        $rows .= "<td>" . $nn . "</td>";
        $rows .= "<td><a href='../createPDF.php?id=$IRN' class='btn btn-primary btn-sm fw-bold w-100' target=_blank>$IRN</a></td>";
        $rows .= "<td>" . $preInvoice["ClientName"] . "</td>";
        $rows .= "<td>" . $preInvoice["TaxableAmount"] . "</td>";
        $rows .= "<td>" . $preInvoice["TaxAmount"] . "</td>";
        $rows .= "<td>" . $preInvoice["PayableAmount"] . "</td>";
        $rows .= "<td>" . $preInvoice["InvoiceIssueDate"] . "</td>";
        $rows .= "<td style='$style' >"  . $preInvoice["contract_id"] . "</td>";
        $rows .= "<td style='$style' >"  . $preInvoice["sent_to_zatca_status"] . "</td>";
        $rows .= "</tr>";
        $response[] = $rows;
        $nn = 1 + $nn;
    }
} else {
    $response[] = "<tr><td colspan='9'>لا توجد معتمدة</td></tr>";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فواتير معتمدة</title>
    <link href="../dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../custom/myCar.css" />
    <!-- <link rel="stylesheet" href="../custom/style.css"> -->
    <link rel="icon" href="../custom/perfect.ico">
    <style>
        .toast {
            background-color: rgba(255, 255, 255, 0.95);
            min-width: 200px;
            text-align: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-radius: 8px;
        }

        .toast-body {
            font-size: 1.2rem;
            padding: 1.5rem;
        }
    </style>
</head>

<body style="background-color: #00324d;">
    <div class="toast-container position-fixed top-50 start-50 translate-middle">
        <div id="actionToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-body fs-5" style="background-color: #cce5ff;"></div>
        </div>
    </div>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-5 mb-3">
                <h4 style="color: #cce5ff;">فواتير معتمدة من منصة فاتورة</h4>
            </div>
            <div class="col-md-7 mb-3">
                <form method="POST" action="" class="d-flex">
                    <div class="col-md-3 mb-3">
                        <input type="date" name="start_date" id="start_date" class="form-control me-2" placeholder="بداية" value="">
                    </div>
                    <div class="col-md-3 mb-3">
                        <input type="date" name="end_date" id="end_date" class="form-control me-2" placeholder="نهاية" value="">
                    </div>
                    <div class="col-md-3 mb-3">
                        <button type="submit" id="get_invoices" class="btn btn-primary">بحث</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="mb-3">
            <input type="text" id="searchInput" class="form-control" placeholder="بحث...">
        </div>
        <!-- table-striped -->
        <div class="panel-body" style="background-color:#00324d ; color:#cce5ff;">
            <!-- <div class="table-responsive"> -->
            <table class="table table-responsive table-bordered table-hover" id="newInvoiceTable">
                <thead class="sticky-top top-0">
                    <tr class="table-info">
                        <th class="text-center" width="4%">م</th>
                        <th>رقم الفاتورة</th>
                        <th>اسم العميل</th>
                        <th>مبلغ الفاتورة</th>
                        <th>الضريبة</th>
                        <th>شامل الضريبة</th>
                        <th>تاريخ الإصدار </th>
                        <th>رقم العقد</th>
                        <th>الحالة</th>
                    </tr>
                </thead>
                <tbody id="invoices_data">
                    <?php
                    foreach ($response as $result) {
                        echo $result;
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const table = document.getElementById('newInvoiceTable');
            const rows = table.getElementsByTagName('tr');

            searchInput.addEventListener('input', function() {
                const searchTerm = searchInput.value.toLowerCase();

                for (let i = 1; i < rows.length; i++) {
                    let row = rows[i];
                    let text = row.textContent.toLowerCase();

                    if (text.includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                }
            });
        });

        function showToast(message) {
            const toastElement = document.getElementById('actionToast');
            const toast = new bootstrap.Toast(toastElement);
            toastElement.querySelector('.toast-body').textContent = message;
            toast.show();
        }
    </script>
    <script>
        function checkSession() {
            fetch('../check_session.php')
                .then(response => response.json())
                .then(data => {
                    if (!data.valid) {
                        window.location.href = '../index.php?expired=1';
                    }
                });
        }

        // Check every 60 seconds
        setInterval(checkSession, 60000);

        //
        document.getElementById('get_invoices').addEventListener('click', async (e) => {
            e.preventDefault();

            fetch('invoices_data.php', {
                    method: 'POST',
                    body: new FormData(document.querySelector('form')),
                })
                .then(response => response.text()) // Parse as text
                .then(html => {
                    document.getElementById("invoices_data").innerHTML = html;
                })
                .catch(error => {
                    console.error("Error:", error);
                    document.getElementById("invoices_data").innerHTML = `<tr><td colspan="9">Error loading data</td></tr>`;
                });
        });
    </script>
    <?php
    ob_end_flush();
    ?>
</body>

</html>