<?php
namespace Allam\Zatca;
include "../vendor/autoload.php";

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
// use Mpdf\Mpdf;

use Allam\Zatca\VatBase;

class CreateInvoice{
    private $VatBase;
    public function __construct()
    {
        $vat = new VatBase();
        $VatBase = $vat->getConnection();
    
        $this->VatBase  = $VatBase;
    }

    function items($invoice_id): array
    {
        $stmt_items = $this->VatBase->prepare('SELECT * FROM invoiceline WHERE invoiceID = ?');
        $stmt_items->execute([$invoice_id]);
        return $stmt_items->fetchAll();
    }

    function supplier(): array
    {
        $sql = $this->VatBase->prepare('SELECT * FROM supplier WHERE id = 1 LIMIT 1');
        $sql->execute();
        return $sql->fetch();
    }
    function prevat($invoice_id): array
    {
        // $sql = $this->VatBase->prepare('SELECT * FROM prevat WHERE invoiceID = ? LIMIT 1');
        // $sql->execute([$invoice_id]);
        // return $sql->fetch();
        $sql = $this->VatBase->prepare('SELECT * FROM prevat WHERE invoiceID = ? LIMIT 1');
        $sql->execute([$invoice_id]);
        $respone = $sql->fetch();
        $respone['payment']="أجل";
        if($respone['paymentType'] === 1){
            $respone['payment']="مسدد";
        }
        return $respone ;
    }
    function zatca($invoice_id): array
    {
        $sql = $this->VatBase->prepare('SELECT * FROM `zatca_documents` WHERE `invoice_id` = ? AND qr_value IS NOT NULL LIMIT 1');
        $sql->execute([$invoice_id]);
        return $sql->fetch();
    }

    function qrCode($qr_value)
    {
        $writer = new PngWriter();

        $qr = new QrCode(
            data: $qr_value,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 300,
            margin: 0,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        return $writer->write($qr);
    }

    function createPDF($invoice_id , $supplier)
    {
        $zatca = $this->zatca($invoice_id);
        $prevat = $this->prevat($invoice_id);
       
         $qr_value = $zatca['qr_value'];
         $qr = $this->qrCode($qr_value);

        $view_data = [
            'supplier' => $supplier,
            'prevat' => $this->prevat($invoice_id),
            'items'  => $this->items($invoice_id),
            'zatca' => $zatca,
            'qr' => $qr->getDataUri()
        ];
        ob_start();
    $zatca_status = $zatca['sent_to_zatca_status'];
    
    if($zatca_status === "CLEARED"){
         include 'stander_temp.php';
    }else{
        include 'simple_temp.php';
    }
       
        $html = ob_get_clean();
        $mpdf = new \Mpdf\Mpdf([
            'PDFA' => true,
            'PDFAauto' => true,
            'fontDir' => [__DIR__ . '/fonts'],
            // 'format' => 'A4',
            'fontdata' => [
                'montserrat' => [
                    'R' => 'Montserrat-Arabic-Light.ttf',
                    'B' => 'Montserrat-Arabic-Light.ttf',
                    'I' => 'Montserrat-Arabic-Light.ttf',
                    'BI' => 'Montserrat-Arabic-Light.ttf',
                    'useOTL' => 0xFF,
                    'useKashida' => 75,
                ]
            ],
            'format' => [300, 435]
        ]);
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        
        $mpdf->SetTitle('فاتورة تأجير سيارة');
        $mpdf->SetAuthor('Al Wesam Cars Renatl');
        // $mpdf->SetSubject('PDF/A-3A Example');
        // $mpdf->SetKeywords('PDF/A-3A, mPDF, PHP');
        
        $view_data = ['view' => false];
        $mpdf->WriteHTML($html);
        if (!is_null($zatca)) {
            // $xml_name = $prevat['VatNumber'] . $prevat['InvoiceIssueDate'] . 'T' . $prevat['InvoiceIssueTime'] . '.xml';
            $xml_name = $invoice_id.'.xml';
            $temp = tmpfile();
            fwrite($temp, base64_decode($zatca['xml']));
            fseek($temp, 0);
            $tmpfile_path = stream_get_meta_data($temp)['uri'];
            $mpdf->SetAssociatedFiles([[
                'name' => $xml_name,
                'mime' => 'text/xml',
                'description' => 'xml',
                'AFRelationship' => 'Alternative',
                'path' => $tmpfile_path
            ]]);
        }
        ob_clean();
        return $mpdf->Output($invoice_id.'.pdf', 'I');
    }

}//class end


// $CreateInvoice = new CreateInvoice();
// $supplier = $CreateInvoice->supplier();
// $invoice_id = "26145";
// $file = $CreateInvoice->createPDF($invoice_id , $supplier);