<?php
namespace Allam\Zatca;

require_once "MainBase.php";
require_once "VatBase.php";
use PDO;

class PreVat{
    private $VatBase;
    private $MainBase;
    public function __construct()
    {
        $main = new MainBase();
        $MainBase = $main->getConnection();
    
        $vat = new VatBase();
        $VatBase = $vat->getConnection();
    
        $this->VatBase  = $VatBase;
        $this->MainBase = $MainBase;
    }

    function client($contract_id) :array 
    {
        $info = array();

        $sql = $this->MainBase->prepare("SELECT customers.StreetName , customers.BuildingNumber , customers.PlotIdentification , customers.PostalNumber ,
                 customers.SubDivisionName,customers.CityName , customers.cust_name as ClientName ,customers.cust_vat as VatNumber , customers.idSA as csr , concat(cars.letters,' ', cars.numbers) as PL , contracts.cust_id2
                 from customers , contracts ,cars
                 where contracts.cust_id = customers.cust_id 
                AND contracts.carid = cars.carid
                AND contracts.contract_id = ?");
        $sql->bindParam(1, $contract_id);
        $sql->execute();
        $info = $sql->fetch();

        return $info;
    }

    function client2($cust_id2)
    {
        $sql = $this->MainBase->prepare("SELECT cust_name as ClientName2 from customers where cust_id = ?");
        $sql->bindParam(1,$cust_id2);
        $sql->execute();
        $info = $sql->fetch();
        return $info['ClientName2'];
    }

    function oldVat():array
    {
        $oldVAT = [] ;
        $pre = $this->VatBase->prepare("SELECT IRN from prevat where IRN > (SELECT MAX(IRN) - 10 from prevat) ORDER BY IRN ASC");
        $pre->execute();
        while ($row = $pre->fetch()) {
            $oldVAT[] = $row['IRN'];
        } 
        return $oldVAT ;    
    }

    function vatData(){
        $oldPreVAT = $this->oldVat();
        $minn = min((array_values($oldPreVAT)))+2;

        $sql = $this->MainBase->prepare("SELECT * from vat where vat_id > ? ORDER BY vat_id ASC ");
        $sql->bindParam(1, $minn);
        $sql->execute();
        if ($sql->rowCount() > 0) {
   $output = [];
   $response = [];
        while ($row = $sql->fetch()) {
                $vat_id = $row['vat_id'];
            if (in_array($vat_id, $oldPreVAT)) continue;

                $contract_id = $row['contract_id'];
                $output = $this->client($contract_id);
                $cust_id2 = $output['cust_id2'] ;
            if(!empty($cust_id2)){$output['ClientName2']= $this->client2($cust_id2); }
            else{$output['ClientName2']= "";}
            $deduction = $row['deduction'] ;
            if(empty($deduction)){$deduction = 0;}
            $net_cost = $row['net_cost'];
            $output['contract_id'] = $contract_id ;
            $output['IRN'] = $vat_id ;
            $output['DeliveryDateTime'] = $row['end'] ;
            $output['paymentType'] = 30 ;
            $output['LineExtensionAmount'] =$net_cost + $deduction ;
            $output['TaxExclusiveAmount'] = $net_cost ;
            $output['TaxInclusiveAmount'] = $row['after_vat'] ;
            $output['AllowanceTotalAmount'] = $deduction ;
            $output['PrepaidAmount'] = 0 ;
            $output['PayableAmount'] = $row['after_vat'] ;
            $output['TaxTotal'] = $row['vat_req'] ;
            $output['TaxableAmount'] = $row['net_cost'] ;
            $output['TaxAmount'] = $row['vat_req'] ;
            $output['TaxPercentage'] = 15.0 ;


            $output['AllowanceChargeAmount'] = $row['deduction'] ;
            $output['AllowanceChargeTaxPercentage'] = 15.0 ;

            $output['start'] = $row['start'] ;

            $output['days_cost']    = $row['days_cost'];
            $output['day_cost']     = $row['day_cost'];
            $output['days_qty']     = $row['days_qty'] ;

            $output['kilos_cost']   = $row['kilos_cost'];
            $output['kilo_qty']     = $row['kilo_qty'] ;

            $output['hours_cost']   = $row['hours_cost'];
            $output['hour_qty']     = $row['hour_qty'] ;

            $output['addtion_cost'] = $row['addtion_cost'];
            $output['violations']   = $row['violations'];
            

            $response [] = $output;
        }
        return $response ;

    }}

    function createVat($father){
        $nn = 1;
        $InvoiceIssueTime = date('H:i:s');
        $InvoiceIssueDate = date('Y-m-d');
        $data = $this->vatData();
        if(!empty($data)){

       foreach($data as $output){

            $ins =  $this->VatBase->prepare("INSERT INTO `prevat`(`IRN`, `contract_id`, `VatNumber`, `StreetName`, `BuildingNumber`,
             `PlotIdentification`, `SubDivisionName`, `CityName`, `PostalNumber`, `ClientName`, `DeliveryDateTime`, `paymentType`,  
            `InvoiceID`, `LineExtensionAmount`, `TaxInclusiveAmount`, `TaxExclusiveAmount`, 
            `AllowanceTotalAmount`, `PrepaidAmount`, `PayableAmount`, `TaxTotal`, `TaxableAmount`, `TaxAmount`, 
            `TaxPercentage`,  `AllowanceChargeAmount`, `AllowanceChargeTaxPercentage`, `father` ,InvoiceIssueTime ,InvoiceIssueDate , csr , start,PL ,ClientName2) 
            VALUES (?,? , ? ,? ,? , ? ,? , ?  ,? , ? ,?,? , ? ,? ,? , ? ,?,? , ? ,? ,? , ? ,?,? , ? ,?,? ,?,?,?,? ,?) ");
            $ins->bindParam(1, $output['IRN']);
            $ins->bindParam(2, $output['contract_id']);
            $ins->bindParam(3, $output['VatNumber']);
            $ins->bindParam(4, $output['StreetName']);
            $ins->bindParam(5, $output['BuildingNumber']);
            $ins->bindParam(6, $output['PlotIdentification']);
            $ins->bindParam(7, $output['SubDivisionName']);
            $ins->bindParam(8, $output['CityName']);
            $ins->bindParam(9, $output['PostalNumber']);
            $ins->bindParam(10, $output['ClientName']);
            $ins->bindParam(11, $output['DeliveryDateTime']);
            $ins->bindParam(12, $output['paymentType']);
            $ins->bindParam(13, $output['IRN']);
            $ins->bindParam(14, $output['LineExtensionAmount']);
            $ins->bindParam(15, $output['TaxInclusiveAmount']);
            $ins->bindParam(16, $output['TaxExclusiveAmount']);
            $ins->bindParam(17, $output['AllowanceTotalAmount']);
            $ins->bindParam(18, $output['PrepaidAmount']);
            $ins->bindParam(19, $output['PayableAmount']);
            $ins->bindParam(20, $output['TaxTotal']);
            $ins->bindParam(21, $output['TaxableAmount']);
            $ins->bindParam(22, $output['TaxAmount']);
            $ins->bindParam(23, $output['TaxPercentage']);
            $ins->bindParam(24, $output['AllowanceChargeAmount']);
            $ins->bindParam(25, $output['AllowanceChargeTaxPercentage']);
            $ins->bindParam(26, $father);
            $ins->bindParam(27, $InvoiceIssueTime);
            $ins->bindParam(28, $InvoiceIssueDate);
            $ins->bindParam(29, $output['csr']); 
            $ins->bindParam(30, $output['start']);
            $ins->bindParam(31, $output['PL']);
            $ins->bindParam(32, $output['ClientName2']);
            if($ins->execute()){
                $line =  $this->VatBase->prepare("INSERT INTO `invoiceline`( `LineName`, `LinePrice`, `LineQuantity`, `LineSubTotal`, `LineTaxTotal`, `LineNetTotal`,`invoiceID`) 
                                    VALUES (?,?,?,?,?,?,?)");
                $days_cost = $output['days_cost'];
                $kilos_cost = $output['kilos_cost'];
                $hours_cost = $output['hours_cost'];
                $addtion_cost = $output['addtion_cost'];
                $violations = $output['violations'];
                if($days_cost > 0){
                    $LineName = "قمية إيجار";
                    $LineTaxTotal = round(($days_cost * 0.15),2);
                    $LineNetTotal =  $LineTaxTotal+$days_cost ;
                    $line->bindParam(1,$LineName );
                    $line->bindParam(2, $output['day_cost']);//LinePrice
                    $line->bindParam(3, $output['days_qty']);//LineQuantity
                    $line->bindParam(4, $days_cost);//LineSubTotal
                    $line->bindParam(5, $LineTaxTotal);//LineTaxTotal
                    $line->bindParam(6, $LineNetTotal);//LineNetTotal
                    $line->bindParam(7,$output['IRN']);//invoiceID
                    $line->execute();
                }
                if($kilos_cost > 0){
                    $LineName = "كيلومتر زائد";
                    $LineTaxTotal = round(($kilos_cost * 0.15),2);
                    $LineNetTotal =  $LineTaxTotal+$kilos_cost ;
                    $kilo_qty = $output['kilo_qty'];
                    $kilo_cost = round(($kilos_cost / $kilo_qty),2);
                    $line->bindParam(1,$LineName );
                    $line->bindParam(2, $kilo_cost);//LinePrice
                    $line->bindParam(3, $kilo_qty);//LineQuantity
                    $line->bindParam(4, $kilos_cost);//LineSubTotal
                    $line->bindParam(5, $LineTaxTotal);//LineTaxTotal
                    $line->bindParam(6, $LineNetTotal);//LineNetTotal
                    $line->bindParam(7,$output['IRN']);//invoiceID
                    $line->execute();
                }
                if($hours_cost > 0){
                    $hour_qty = $output['hour_qty'];
                    $LineName = "ساعات $hour_qty  وقت إضافي أقل من";
                    $LineTaxTotal = round(($hours_cost * 0.15),2);
                    $LineNetTotal =  $LineTaxTotal+$hours_cost ;
                    $peroid = 1;
                    // $hour_cost = round(($hours_cost / $hour_qty),2);
                    $line->bindParam(1,$LineName );
                    $line->bindParam(2, $hours_cost);
                    $line->bindParam(3, $peroid);
                    $line->bindParam(4, $hours_cost);
                    $line->bindParam(5, $LineTaxTotal);
                    $line->bindParam(6, $LineNetTotal);
                    $line->bindParam(7,$output['IRN']);
                    $line->execute();
                }
                if($addtion_cost > 0){
                    $LineName = "تعويض إضافي";
                    $LineTaxTotal = round(($addtion_cost * 0.15),2);
                    $LineNetTotal =  $LineTaxTotal+$addtion_cost ;
                    $qty = "1";

                    $line->bindParam(1, $LineName );
                    $line->bindParam(2, $addtion_cost);
                    $line->bindParam(3, $qty);
                    $line->bindParam(4, $addtion_cost);
                    $line->bindParam(5, $LineTaxTotal);
                    $line->bindParam(6, $LineNetTotal);
                    $line->bindParam(7, $output['IRN']);
                    $line->execute();
                }
                if($violations > 0){
                    $LineName = "مخالفات";
                    $LineTaxTotal = 0.0;
                    $LineNetTotal =  $LineTaxTotal+$violations ;
                    $qty = "1";
                    $TaxPercentage = 0;
        $line =  $this->VatBase->prepare("INSERT INTO `invoiceline`( `LineName`, `LinePrice`, `LineQuantity`, `LineSubTotal`, `LineTaxTotal`, `LineNetTotal`,`invoiceID`,TaxPercentage) 
                                    VALUES (?,?,?,?,?,?,?,?)");
                    $line->bindParam(1, $LineName );
                    $line->bindParam(2, $violations);
                    $line->bindParam(3, $qty);
                    $line->bindParam(4, $violations);
                    $line->bindParam(5, $LineTaxTotal);
                    $line->bindParam(6, $LineNetTotal);
                    $line->bindParam(7, $output['IRN']);
                    $line->bindParam(8, $TaxPercentage);
                    $line->execute();
                }
            }
            $nn++;
        }
        $nn--;
        return "تمت الإضافة  $nn بنجاح";   
}else{
        return "لا يوجد فواتير بدون استيراد" ;
}

}

function checkID($id) : bool
{
   $sql = $this->VatBase->prepare("SELECT *  FROM  zatca_documents 
                    WHERE  sent_to_zatca_status IN('CLEARED','REPORTED') 
                    AND invoice_id	= ?");
  $sql->bindParam(1,$id, PDO::PARAM_INT); 
  $sql->execute();
  return $sql->rowCount()> 0 ;           
}

function deleteVat(int $id):string
{
    if ($this->checkID($id)){
        return " لا يمكن حذف السجل الفاتروة الحالية ";
        exit();
    }
    $del =  $this->VatBase->prepare("SELECT * FROM prevat WHERE IRN >= ?");
    $del->bindParam(1,$id, PDO::PARAM_INT);
    if($del->execute()){
        $deletedRecords = $del->rowCount();
    }

if( $deletedRecords > 0){
            $sql = $this->VatBase->prepare("DELETE FROM invoiceline WHERE invoiceID	>= ?");
            $sql->bindParam(1,$id, PDO::PARAM_INT);
         if($sql->execute()){
            
            $sql2 = $this->VatBase->prepare("DELETE FROM prevat WHERE IRN >= ?");
            $sql2->bindParam(1,$id, PDO::PARAM_INT);
            $sql2->execute();
        }

        return "تم حذف $deletedRecords فاتورة";
    }else{
        return "لا توجد فواتر للحذف";
    }
    
}

} //class end
    

// $pre = new PreVat();
// $father = 3;

// $nany = $pre->createVat($father);
// print_r($nany)  ;

