<?php
namespace Allam\Zatca;
include "../vendor/autoload.php";

use Allam\Zatca\Invoice\Client;
use Allam\Zatca\Invoice\Supplier;
use Allam\Zatca\Invoice\Delivery;
use Allam\Zatca\Invoice\PaymentType;
use Allam\Zatca\Invoice\PIH;
use Allam\Zatca\Invoice\ReturnReason;
use Allam\Zatca\Invoice\BillingReference;
use Allam\Zatca\Invoice\AdditionalDocumentReference;
use Allam\Zatca\Invoice\LegalMonetaryTotal;
use Allam\Zatca\Invoice\TaxesTotal;
use Allam\Zatca\Invoice\TaxSubtotal;
use Allam\Zatca\Invoice\LineTaxCategory;
use Allam\Zatca\Invoice\InvoiceLine;
use Allam\Zatca\Invoice\AllowanceCharge;
use Allam\Zatca\Invoice\InvoiceGenerator;

use Allam\Zatca\VatBase;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;

use DateTime;

$vatbase = new VatBase();

$conn = $vatbase->getConnection();

class SendToZatca{
    private $VatBase;
    public function __construct()
    {
        $vat = new VatBase();
        $VatBase = $vat->getConnection();
    
        $this->VatBase  = $VatBase;
    }
    function generateUUIDv4() {
        $data = random_bytes(16); 
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // Set version to 0100 
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // Set bits 6-7 to 10 
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4)); 
    }
    function vatENV():array
    {
        $sql = $this->VatBase->prepare("SELECT * from vatENV where id = 2");//1 simulation 2 for core
        $sql->execute();
        $vatENV = $sql->fetch();
        return $vatENV ;
    }

    function dbSupplier():array
    {
        $sql = $this->VatBase->prepare("SELECT * FROM `supplier`");
        $sql->execute();
        $dbSupplier = $sql->fetch();
        return $dbSupplier ;
    }

    function preVAT($invoice_id):array
    {
        $sql = $this->VatBase->prepare("SELECT * from prevat where IRN = ?");
        $sql->bindParam(1,$invoice_id);
        $sql->execute();
        $preVAT = $sql->fetch();
        return $preVAT ;
    }

    function isSigned($invoice_id):bool{
        $sql = $this->VatBase->prepare("SELECT * FROM `zatca_documents` WHERE invoice_id = ? AND sent_to_zatca = 1") ;
        $sql->bindParam(1, $invoice_id);
        $sql->execute();
        return $sql->rowCount() > 0;
    }

    function insertDocument($invoice_id) : bool | array
    {
        $initial = array();
        $max = $this->VatBase->prepare("SELECT `hash`  FROM `zatca_documents` where icv = (SELECT MAX(`icv`) as icv from zatca_documents where `hash` IS NOT NULL)");
        $max->execute();
        
        $maxRow = $max->fetch();
        $pih    = $maxRow['hash'];

        $max = $this->VatBase->prepare("SELECT MAX(`icv`) as icv from zatca_documents");
        $max->execute();
        
        $maxRow = $max->fetch();
        $icv    = $maxRow['icv'];
        
        $uuid   = $this->generateUUIDv4() ;
        
            if(empty($icv)){    $icv = 1 ;
            
            }else{
            $icv = $icv + 1;
            }
        if(empty($pih)){
           $pih = base64_encode(hash('sha256','0',true));
            }
        ///need test
            $sql = $this->VatBase->prepare("INSERT INTO zatca_documents(icv,invoiceType,uuid , invoice_id )
                                VALUES (? , 388 ,?, ?)");
        
            $sql->bindParam(1,$icv);
            $sql->bindParam(2,$uuid);
            $sql->bindParam(3,$invoice_id);
           if($sql->execute()){
            $initial['icv']     = $icv;
            $initial['uuid']    = $uuid ;
            $initial['pih']     = $pih ;

            return $initial ;
           }else{
            return false;
           }
        
    }

    public function sendInvoice($invoice_id , $vatENV , $dbSupplier, $preVAT ):array
    { 
        $initial = $this->insertDocument($invoice_id);
        // $response =array();
        $vatNumber = $preVAT['VatNumber'] ;
        if(empty($vatNumber)){
            $client = (new Client())
        ->setCountryName('SA')
        ->setClientName($preVAT['ClientName']);
        $InvoiceType = '0200000';
        $message_key = "reportingStatus";
        }else{
            $client = (new Client())
        ->setVatNumber($vatNumber)
        ->setStreetName($preVAT['ClientName'])
        ->setBuildingNumber($preVAT['BuildingNumber'])
        ->setPlotIdentification($preVAT['PlotIdentification'])
        ->setSubDivisionName($preVAT['SubDivisionName'])
        ->setCityName($preVAT['CityName'])
        ->setPostalNumber($preVAT['PostalNumber'])
        ->setCountryName($preVAT['CountryName'])
        ->setClientName($preVAT['ClientName']);
        $InvoiceType = '0100000';
        $message_key = "clearanceStatus";
        }
        
        
        $supplier = (new Supplier())
        ->setCrn($dbSupplier['Crn'])
        ->setStreetName($dbSupplier['StreetName'])
        ->setBuildingNumber($dbSupplier['BuildingNumber'])
        ->setPlotIdentification($dbSupplier['PlotIdentification'])
        ->setSubDivisionName($dbSupplier['SubDivisionName'])
        ->setCityName($dbSupplier['CityName'])
        ->setPostalNumber($dbSupplier['PostalNumber'])
        ->setCountryName('SA')
        ->setVatNumber($dbSupplier['VatNumber'])
        ->setVatName($dbSupplier['VatName']);
        
        $delivery = (new Delivery())
        ->setDeliveryDateTime($preVAT['DeliveryDateTime']);
        
        $paymentType = (new PaymentType())
        ->setPaymentType($preVAT['paymentType']); // 10
        
        // $returnReason = (new ReturnReason())
        // ->setReturnReason('SET_RETURN_REASON');
        
        $previous_hash = (new PIH())
        ->setPIH($initial['pih']); 
        
        // $billingReference = (new BillingReference())
        // ->setBillingReference('23'); // note this used when type credit or debit this value of parent invoice id
        
        $additionalDocumentReference = (new AdditionalDocumentReference())
        ->setInvoiceID($initial['icv']); 
        
        $legalMonetaryTotal = (new LegalMonetaryTotal())
        ->setTotalCurrency('SAR')
        ->setLineExtensionAmount($preVAT['LineExtensionAmount'])
        ->setTaxExclusiveAmount($preVAT['TaxExclusiveAmount'])
        ->setTaxInclusiveAmount($preVAT['TaxInclusiveAmount'])
        ->setAllowanceTotalAmount($preVAT['AllowanceTotalAmount'])
        ->setPrepaidAmount($preVAT['PrepaidAmount'])
        ->setPayableAmount($preVAT['PayableAmount']);
        
        $taxesTotal = (new TaxesTotal())
        ->setTaxCurrencyCode('SAR')
        ->setTaxTotal($preVAT['TaxTotal']);
        
        $taxSubtotal = (new TaxSubtotal())
        ->setTaxCurrencyCode('SAR')
        ->setTaxableAmount($preVAT['TaxableAmount'])
        ->setTaxAmount($preVAT['TaxAmount'])
        ->setTaxCategory('S')
        ->setTaxPercentage(15)
        ->getElement();
        
        $itemTaxCategory = (new LineTaxCategory())
        ->setTaxCategory('S')
        ->setTaxPercentage(15)
        ->getElement();

        $itemTaxCategory2 = (new LineTaxCategory())
        ->setTaxCategory('Z')
        ->setTaxPercentage(0)
        ->getElement();
        
        $sql = $this->VatBase->prepare("SELECT * FROM `invoiceline` WHERE `invoiceID` = ?");
        $sql->bindParam(1,$invoice_id);
        $sql->execute();
        $CAT = $itemTaxCategory ;
        while ($dbLines = $sql->fetch()) {
            if($dbLines['TaxPercentage']== 0){
                $CAT = $itemTaxCategory2 ;
            }
            $invoiceLines[] = (new InvoiceLine())
            ->setLineID($dbLines['LineID'])
            ->setLineName($dbLines['LineName'])
            ->setLineCurrency('SAR')
            ->setLinePrice($dbLines['LinePrice'])
            ->setLineQuantity($dbLines['LineQuantity'])
            ->setLineSubTotal($dbLines['LineSubTotal'])
            ->setLineTaxTotal($dbLines['LineTaxTotal'])
            ->setLineNetTotal($dbLines['LineNetTotal'])
            ->setLineTaxCategories($CAT)
            ->setLineDiscountReason('reason')
            ->setLineDiscountAmount(0.0)
            ->getElement();
        }
        
        
        $allowanceCharge = (new AllowanceCharge())
        ->setAllowanceChargeCurrency('SAR')
        ->setAllowanceChargeIndex($preVAT['AllowanceChargeIndex'])
        ->setAllowanceChargeAmount($preVAT['AllowanceChargeAmount'])
        ->setAllowanceChargeTaxCategory('S')
        ->setAllowanceChargeTaxPercentage($preVAT['AllowanceChargeTaxPercentage'])
        ->getElement();
        
        
        $response = (new InvoiceGenerator())
        ->setZatcaEnv($vatENV['ZatcaEnv'])//'developer-portal'
        ->setZatcaLang('en')
        ->setInvoiceNumber($preVAT['InvoiceID'])
        ->setInvoiceUuid($initial['uuid'])// how to generate
        ->setInvoiceIssueDate($preVAT['InvoiceIssueDate'])
        ->setInvoiceIssueTime($preVAT['InvoiceIssueTime'])
        ->setInvoiceType($InvoiceType,'388')//0100000 company or 0200000  normal customer
        ->setInvoiceCurrencyCode('SAR')
        ->setInvoiceTaxCurrencyCode('SAR')
        // ->setInvoiceBillingReference($billingReference) // use this when document type is credit or debit
        ->setInvoiceAdditionalDocumentReference($additionalDocumentReference)
        ->setInvoicePIH($previous_hash)
        ->setInvoiceSupplier($supplier)
        ->setInvoiceClient($client)
        ->setInvoiceDelivery($delivery)
        ->setInvoicePaymentType($paymentType)
        //->setInvoiceReturnReason($returnReason) use this when document type is credit or debit
        ->setInvoiceLegalMonetaryTotal($legalMonetaryTotal)
        ->setInvoiceTaxesTotal($taxesTotal)
        ->setInvoiceTaxSubTotal($taxSubtotal)
        ->setInvoiceAllowanceCharges($allowanceCharge)
        ->setInvoiceLines(...$invoiceLines)
        ->setCertificateEncoded($vatENV['productionCertificate'])
        ->setPrivateKeyEncoded($vatENV['privateKey'])
        ->setCertificateSecret($vatENV['productionCertificateSecret'])
        ->sendDocument(true);

        $response['message_key']= $message_key ;
        $response['icv'] = $initial['icv'];
        return $response ;
    }

    function saveDocument($invoice_id, $vatENV, $dbSupplier):string
    {

        if($this->isSigned($invoice_id)){
            return "false" ;
        }
        $preVAT = $this->preVAT($invoice_id);
        $response = $this->sendInvoice($invoice_id, $vatENV, $dbSupplier, $preVAT);
        if ($response['success']) {
            $sent_to_zatca_status = $response['response']->{$response['message_key']};
            $stringResponse = json_encode($response['response'], JSON_PRETTY_PRINT);

            $hash = $response['hash'];
            $xml = $response['xml'];
            $qr_value = $response['qr_value'];
            //
            $dateTime = new DateTime($response['signing_time']);
            $signing_time = $dateTime->format('Y-m-d H:i:s');
            $sent_to_zatca = 1;
            if (($sent_to_zatca_status == "REPORTED") || ($sent_to_zatca_status == "CLEARED")) {
                $sent_to_zatca = 1;
            } else {
                $sent_to_zatca = 0;
            }

            $sql = $this->VatBase->prepare("UPDATE zatca_documents SET hash = ? , xml = ? ,sent_to_zatca = ?  , sent_to_zatca_status = ? , signing_time = ? , response = ? , qr_value = ?
            WHERE icv = ?");

            $sql->bindParam(1, $hash);
            $sql->bindParam(2, $xml);
            $sql->bindParam(3, $sent_to_zatca);
            $sql->bindParam(4, $sent_to_zatca_status);
            $sql->bindParam(5, $signing_time);
            $sql->bindParam(6, $stringResponse);
            $sql->bindParam(7, $qr_value);
            $sql->bindParam(8, $response['icv']);
            $sql->execute();
            return $sent_to_zatca_status ;
        }else{
            return "false" ;
        }
        
}

    // QR code
    function pngQR($qr_value)
    {
        $writer = new PngWriter();

        $qrCode = new QrCode(
            data: $qr_value,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 300,
            margin: 10,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        $result = $writer->write($qrCode);
        return " <img src='" . $result->getDataUri() . "'> ";
    }
}

// $zatca = new SendToZatca();

// $vatENV = $zatca->vatENV();

// $dbSupplier = $zatca->dbSupplier();

// $invoice_id = 28145 ;


// $zatca->saveDocument($invoice_id, $vatENV, $dbSupplier);




