<?php
session_start( [ 
  'name' => 'PHPSESSID',
  'sid_length' => 128,
  'sid_bits_per_character' => 6,
  'use_strict_mode' => true,
  'referer_check' => $_SERVER['HTTP_HOST'],
  ]);
  // session_set_cookie_params(
  //   $currentCookieParams["secure"],
  //   $currentCookieParams["httponly"]
  // );
ob_start();

// session_start();
require_once 'config.php';
require_once 'send_email.php';

function generateToken() {
    return bin2hex(random_bytes(32));
}

function updateToken($userId, $pdo) {
    $token = generateToken();
    $expiry = date('Y-m-d H:i:s', strtotime('+30 minutes'));
    
    $stmt = $pdo->prepare("UPDATE users SET refresh_token = ?, token_expiry = ? WHERE id = ?");
    $stmt->execute([$token, $expiry, $userId]);
    
    $_SESSION['token'] = $token;
    $_SESSION['token_expiry'] = $expiry;
}

function checkLockout($username, $pdo) {
    $stmt = $pdo->prepare("SELECT login_attempts, locked_until FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && $user['locked_until'] !== null) {
        if (strtotime($user['locked_until']) > time()) {
            return false; // Still locked
        } else {
            // Reset lockout if time has passed
            $stmt = $pdo->prepare("UPDATE users SET login_attempts = 0, locked_until = NULL WHERE username = ?");
            $stmt->execute([$username]);
        }
    }
    return true;
}

function incrementLoginAttempts($username, $pdo) {
    $stmt = $pdo->prepare("UPDATE users SET login_attempts = login_attempts + 1 WHERE username = ?");
    $stmt->execute([$username]);

    $stmt = $pdo->prepare("SELECT login_attempts FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $attempts = $stmt->fetchColumn();

    if ($attempts >= 2) {
        $lockUntil = date('Y-m-d H:i:s', strtotime('+30 minutes'));
        $stmt = $pdo->prepare("UPDATE users SET locked_until = ? WHERE username = ?");
        $stmt->execute([$lockUntil, $username]);
        
        // Send email notification
        sendLockoutEmail($username);
        return false;
    }
    return true;
}

function resetLoginAttempts($username, $pdo) {
    $stmt = $pdo->prepare("UPDATE users SET login_attempts = 0, locked_until = NULL WHERE username = ?");
    $stmt->execute([$username]);
}

if(isset($_POST['login_credentials'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    if (!checkLockout($username, $pdo)) {
        header("Location: index.php?error=locked");
        exit();
    }

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
     sendLockoutEmail($username);
    if($user && password_verify($password, $user['password'])) {
        resetLoginAttempts($username, $pdo);
        $_SESSION['user_id'] = $user['id'];
        
        updateToken($user['id'], $pdo);
        header("Location: dashboard.php");
        exit();
    } else {
        if (!incrementLoginAttempts($username, $pdo)) {
            header("Location: index.php?error=locked");
            exit();
        }
        header("Location: index.php?error=invalid");
        exit();
    }
}

elseif(isset($_POST['login_apikey'])) {
    $apikey = $_POST['apikey'];
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE api_key = ?");
    $stmt->execute([$apikey]);
    $user = $stmt->fetch();
    
    if($user) {
        $_SESSION['user_id'] = $user['id'];
        updateToken($user['id'], $pdo);
        header("Location: dashboard.php");
        exit();
    }
}

header("Location: index.php?error=1");
exit();