
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <meta name="x-apple-disable-message-reformatting">
  <title></title>
  <style>
        body{
            background-color: #faf9f9;
        }
        body *{
            font-family: 'montserrat';
        }
        @page {
            margin: 30px 15px;
        }
        .base_container{
            margin-top: 30px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 8px;
        }
        .invoice_title{
            margin: 0;
            text-align: center;
            font-family: 'almarai';
            direction: rtl;
            margin-bottom: 10px;
        }
        .invoice_details_container{
            background-color: #ececec;
            border-radius: 15px;
            padding: 10px 10px;
        }
        .invoice_details_parent_table{
            width: 100%;
            direction: rtl;
        }
        .invoice_details_parent_table .invoice_details_parent_td_first{
            width: 33%;
            vertical-align: baseline;
        }
        .invoice_details_parent_table .invoice_details_parent_td_second{
            text-align: center;
            width: 33%;
        }
        .invoice_details_parent_table .invoice_details_parent_td_third{
            width: 33%;
            vertical-align: baseline;
        }
        .invoice_details_parent_table .invoice_details_parent_td_first table,.invoice_details_parent_table .invoice_details_parent_td_third table{
            width: 100%;
        }
        .invoice_details_parent_table .invoice_details_parent_td_first td{
            direction: rtl;
            text-align: right;
            padding: 8px;
        }
        .invoice_details_parent_table .invoice_details_parent_td_third td{
            direction: ltr;
            text-align: left;
            padding: 8px;
        }
        h2{
            font-size: 18px !important;
        }
        h3{
            font-size: 15px !important;
        }
        h4{
            font-size: 16px !important;
            font-weight: lighter;
        }
        .qr_code{
            width: 180px;
            margin: auto;
            display: block;
        }
        .invoice_content_parent{
            margin-top: 8px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 10px;
        }
        .invoice_content_parent .seller_table_heading{
            width: 100%;
            direction: rtl;
        }
        .invoice_content_parent .seller_table_heading .seller_table_heading_first_td{
            width: 50%;
            direction: rtl;
            text-align: right;
        }
        .invoice_content_parent .seller_table_heading .seller_table_heading_second_td{
            width: 50%;
            direction: ltr;
            text-align: left;
        }
        .invoice_content_parent .seller_name_table_heading{
            width: 100%;
            direction: rtl;
        }
        .invoice_content_parent .seller_name_table_heading .seller_name_table_heading_first_td{
            width: 50%;
            direction: rtl;
            text-align: right;
            background-color: #dedede;
            padding: 10px;
        }
        .invoice_content_parent .seller_name_table_heading .seller_name_table_heading_second_td{
            width: 50%;
            direction: ltr;
            text-align: left;
            background-color: #dedede;
            padding: 10px;
        }
        .invoice_content_parent .seller_trn_table_heading{
            width: 100%;
            direction: rtl;
        }
        .invoice_content_parent .seller_trn_table_heading .seller_trn_table_heading_first_td{
            width: 50%;
            direction: rtl;
            text-align: right;
            background-color: #dedede;
            padding: 10px;
        }
        .invoice_content_parent .seller_trn_table_heading .seller_trn_table_heading_second_td{
            width: 50%;
            direction: ltr;
            text-align: left;
            background-color: #dedede;
            padding: 10px;
        }
        .invoice_items_parent{
            margin-top: 8px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 10px;
        }
        .items_table{
            width: 100%;
            direction: rtl;
            border-collapse: separate;
            border-spacing: 0;
        }
        .items_table td{
            text-align: center;
            font-size: 17px;
            font-weight: bold;
        }
        .items_table .items_table_header td{
            background-color: #dedede;
            padding: 5px;
        }
        .items_table .items_table_item_details td{
            padding: 15px;
        }
        .invoice_totals_table{
            border-collapse: collapse;
            width: 100%;
        }
        .invoice_totals_table td{
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }
        .invoice_totals_table .invoice_total_td{
            border: 1px solid black;
            padding: 25px;
        }
  </style>
</head>
<body style="margin:0;padding:0;">
    <div class="base_container">
        <h1 class="invoice_title">فاتورة ضريبية Tax invoice</h1>
        <div class="invoice_details_container">
            <table class="invoice_details_parent_table">
                <tbody>
                    <tr>
                        <td class="invoice_details_parent_td_first">
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <h2>الرقم التسلسلي</h2>
                                            <h4><?= $view_data['prevat']['IRN'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>تاريخ اصدار الفاتورة</h2>
                                            <h4><?= $view_data['prevat']['InvoiceIssueDate'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>تاريخ التوريد</h2>
                                            <h4><?= $view_data['prevat']['DeliveryDateTime'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td class="invoice_details_parent_td_second">
                            <img class="qr_code" src="<?= $view_data['qr'] ?>">
                        </td>
                        <td class="invoice_details_parent_td_third">
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <h2>Invoice reference number (IRN)</h2>
                                            <h4><?= $view_data['prevat']['IRN'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>Issue Date</h2>
                                            <h4><?= $view_data['prevat']['InvoiceIssueDate'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>Supply Date</h2>
                                            <h4><?= $view_data['prevat']['DeliveryDateTime'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="invoice_content_parent">
            <!-- Seller Details Begin -->
            <table class="seller_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h2>هوية المورد</h2>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h2>Seller Identification</h2>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h3>اسم المورد</h3>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h3>Seller Name</h3>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_name_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_name_table_heading_first_td">
                            <h4><?= $view_data['supplier']['VatName'] ?? '-' ?></h4>
                        </td>
                        <td class="seller_name_table_heading_second_td">
                            <h4><?= $view_data['supplier']['VatName'] ?? '-' ?></h4>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_table_heading" style="margin-top: 10px;">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h3>رقم تسجيل ضريبة القيمة المضافة</h3>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h3>VAT Registration Number</h3>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_trn_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_trn_table_heading_first_td">
                            <h4><?= $view_data['supplier']['VatNumber'] ?? '-' ?></h4>
                        </td>
                        <td class="seller_trn_table_heading_second_td">
                            <h4><?= $view_data['supplier']['VatNumber'] ?? '-' ?></h4>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>رقم المعرفات الإضافية للمورد</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Additional Seller ID Number</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['Crn'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['Crn'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>نوع المعرفات الإضافية للمورد</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Additional Seller ID Type</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4>السجل التجاري</h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4>Commercial Registration (CR)</h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <table class="seller_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h2>العنوان</h2>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h2>Address</h2>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h3><?= $view_data['supplier']['StreetName'] ?? '-' ?></h3>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h3><?= $view_data['supplier']['StreetName'] ?? '-' ?></h3>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table class="seller_name_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_name_table_heading_first_td">
                            <h4>Street Name</h4>
                        </td>
                        <td class="seller_name_table_heading_second_td">
                            <h4><?= $view_data['supplier']['StreetName'] ?? '-' ?></h4>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>المدينة</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>City</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['CityName'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['CityName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>رقم المبني</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Building Number</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['BuildingNumber'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['BuildingNumber'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>رمز الدولة</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Country Code</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['CountryName'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['CountryName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>اسم الحي</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>District</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['SubDivisionName'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['SubDivisionName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>الرمز البريدى</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Postal Code</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h4><?= $view_data['supplier']['PostalNumber'] ?? '-' ?></h4>
                                    </td>
                                    <td class="seller_trn_table_heading_second_td">
                                        <h4><?= $view_data['supplier']['PostalNumber'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%"></td>
                </tr>
            </table>
            <!-- Seller Details End -->
            <!-- Buyer Details Begin -->
            <div class="invoice_content_parent" style="margin: 40px 10px;">
                <table class="seller_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h2>هوية العميل</h2>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h2>Buyer Identification</h2>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h3>اسم العميل</h3>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h3>Buyer Name</h3>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_name_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_name_table_heading_first_td">
                                <h4><?= $view_data['prevat']['ClientName'] ?? '-' ?></h4>
                            </td>
                            <td class="seller_name_table_heading_second_td">
                                <h4><?= $view_data['prevat']['ClientName'] ?? '-' ?></h4>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_table_heading" style="margin-top: 10px;">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h3>رقم تسجيل ضريبة القيمة المضافة</h3>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h3>VAT Registration Number</h3>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_trn_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_trn_table_heading_first_td">
                                <h4><?= $view_data['prevat']['VatNumber'] ?? '-' ?></h4>
                            </td>
                            <td class="seller_trn_table_heading_second_td">
                                <h4><?= $view_data['prevat']['VatNumber'] ?? '-' ?></h4>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table width="100%" dir="rtl">
                    <tr>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>رقم المعرفات الإضافية للمورد</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>Additional Seller ID Number</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['VatNumber'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['VatNumber'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>نوع المعرفات الإضافية للمورد</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>Additional Seller ID Type</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4>السجل التجاري</h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4>Commercial Registration (CR)</h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </table>
                <table class="seller_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h2>العنوان</h2>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h2>Address</h2>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h3>اسم الشارع</h3>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h3>Street Name</h3>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="seller_name_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_name_table_heading_first_td">
                                <h4><?= $view_data['prevat']['StreetName'] ?? '-' ?></h4>
                            </td>
                            <td class="seller_name_table_heading_second_td">
                                <h4><?= $view_data['prevat']['StreetName'] ?? '-' ?></h4>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table width="100%" dir="rtl">
                    <tr>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>المدينة</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>City</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['CityName'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['CityName'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>رقم المبني</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>Building Number</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['BuildingNumber'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['BuildingNumber'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="100%" dir="rtl">
                    <tr>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>رمز الدولة</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>Country Code</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['CountryName'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['CountryName'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>اسم الحي</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>District</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['SubDivisionName'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['SubDivisionName'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="100%" dir="rtl">
                    <tr>
                        <td width="50%">
                            <table class="seller_table_heading" style="margin-top: 10px;">
                                <tbody>
                                    <tr>
                                        <td class="seller_table_heading_first_td">
                                            <h3>الرمز البريدى</h3>
                                        </td>
                                        <td class="seller_table_heading_second_td">
                                            <h3>Postal Code</h3>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="seller_trn_table_heading">
                                <tbody>
                                    <tr>
                                        <td class="seller_trn_table_heading_first_td">
                                            <h4><?= $view_data['prevat']['PostalNumber'] ?? '-' ?></h4>
                                        </td>
                                        <td class="seller_trn_table_heading_second_td">
                                            <h4><?= $view_data['prevat']['PostalNumber'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td width="50%"></td>
                    </tr>
                </table>
            </div>
            <!-- Item Details Begin -->
            <div class="invoice_items_parent" style="margin: 40px 10px;">
                <table class="seller_table_heading">
                    <tbody>
                        <tr>
                            <td class="seller_table_heading_first_td">
                                <h2>معلومات وبيانات السلعة أو الخدمة</h2>
                            </td>
                            <td class="seller_table_heading_second_td">
                                <h2>Line Items</h2>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <table class="items_table" style="margin-top: 10px;">
                    <tbody>
                        <tr class="items_table_header">
                            <td>
                                <table>
                                    <tr><td>إجمالي المبلغ شامل ضريبة القيمة المضافة</td></tr>
                                    <tr><td>Subtotal Inclusive of VAT</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>إجمالي المبلغ غير شامل ضريبة القيمة المضافة</td></tr>
                                    <tr><td>Subtotal Exclusive of VAT</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>مبلغ ضريبة القيمة المضافة</td></tr>
                                    <tr><td>VAT Amount</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>معدل ضريبة القيمة المضافة</td></tr>
                                    <tr><td>VAT Rate</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>الكمية</td></tr>
                                    <tr><td>Quantity</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>سعر الوحدة</td></tr>
                                    <tr><td>Unit Price</td></tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr><td>وصف السلعة أو الخدمة</td></tr>
                                    <tr><td>Product or Service Description</td></tr>
                                </table>
                            </td>
                        </tr>
                        <?php foreach ($view_data['items'] as $item) { ?>
                        <tr class="items_table_item_details">
                            <td><?= $item['LineNetTotal'] ?> <?= $item['LineCurrency'] ?></td>
                            <td><?= $item['LineSubTotal'] ?> <?= $item['LineCurrency'] ?></td>
                            <td><?= $item['LineTaxTotal'] ?> <?= $item['LineCurrency'] ?></td>
                            <td><?= $view_data['prevat']['TaxPercentage'] ?> %</td>
                            <td><?= $item['LineQuantity'] ?></td>
                            <td><?= $item['LinePrice'] ?> <?= $item['LineCurrency'] ?></td>
                            <td><?= $item['LineName'] ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Item Details End -->
            <!-- Total Details Begin -->
            <div class="invoice_total_parent" style="margin: 40px 10px;">
                <table width="100%" style="direction: rtl;">
                    <tbody>
                        <tr>
                            <td width="40%"></td>
                            <td width="60%">
                                <table class="invoice_totals_table">
                                  <tbody>
                                    <tr>
                                        <td class="invoice_total_td"><?= $view_data['prevat']['AllowanceChargeAmount'] ?> SAR</td>
                                        <td class="invoice_total_td">
                                            <table width="100%">
                                                <tr><td>خصم على مستوى الفاتورة</td></tr>
                                                <tr><td>Discount at Document Level</td></tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="invoice_total_td"><?= $view_data['prevat']['TaxExclusiveAmount'] ?> SAR</td>
                                        <td class="invoice_total_td">
                                            <table width="100%">
                                                <tr><td>المبلغ الخاضع للضريبة (غير شامل ضريبة القيمة المضافة)</td></tr>
                                                <tr><td>Invoice Taxable Amount</td></tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="invoice_total_td"><?= $view_data['prevat']['TaxAmount'] ?> SAR</td>
                                        <td class="invoice_total_td">
                                            <table width="100%">
                                                <tr><td>اجمالى مبلغ ضريبة القيمة المضافة</td></tr>
                                                <tr><td>VAT Total Amount</td></tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="invoice_total_td"><?= $view_data['prevat']['TaxInclusiveAmount'] ?> SAR</td>
                                        <td class="invoice_total_td">
                                            <table width="100%">
                                                <tr><td>إجمالي قيمة الفاتورة (شامل ضريبة القيمة المضافة)</td></tr>
                                                <tr><td>Invoice Gross Total (Inclusive of VAT)</td></tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="invoice_total_td"><?= $view_data['prevat']['PayableAmount'] ?> SAR</td>
                                        <td class="invoice_total_td">
                                            <table width="100%">
                                                <tr><td>إجمالي مبلغ الفاتورة المستحق الدفع</td></tr>
                                                <tr><td>Invoice Total Payable Amount</td></tr>
                                            </table>
                                        </td>
                                    </tr>
                                  </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Total Details End -->
        </div>
    </div>
</body>
</html>