<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="x-apple-disable-message-reformatting">
    <title></title>
    <style>
        body {
            background-color: #faf9f9;
        }

        body * {
            font-family: 'montserrat';
        }

        @page {
            margin: 10px 15px;
        }

        .base_container {
            margin-top: 10px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 8px;
        }

        .invoice_title {
            margin: 0;
            text-align: center;
            font-family: 'almarai';
            direction: rtl;
            margin-bottom: 10px;
        }

        .invoice_details_container {
            background-color: #ececec;
            border-radius: 15px;
            padding: 10px 10px;
        }

        .invoice_details_parent_table {
            width: 100%;
            direction: rtl;
        }

        .invoice_details_parent_table .invoice_details_parent_td_first {
            width: 33%;
            vertical-align: baseline;
        }

        .invoice_details_parent_table .invoice_details_parent_td_second {
            text-align: center;
            width: 33%;
        }

        .invoice_details_parent_table .invoice_details_parent_td_third {
            width: 33%;
            vertical-align: baseline;
        }

        .invoice_details_parent_table .invoice_details_parent_td_first table,
        .invoice_details_parent_table .invoice_details_parent_td_third table {
            width: 100%;
        }

        .invoice_details_parent_table .invoice_details_parent_td_first td {
            direction: rtl;
            text-align: right;
            padding: 8px;
        }

        .invoice_details_parent_table .invoice_details_parent_td_third td {
            direction: ltr;
            text-align: left;
            padding: 8px;
        }

        h2 {
            font-size: 18px !important;
        }

        h3 {
            font-size: 15px !important;
        }

        h4 {
            font-size: 16px !important;
            font-weight: lighter;
        }

        .qr_code {
            width: 190px;
            margin:6px;
            display: block;
        }

        .invoice_content_parent {
            margin-top: 8px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 10px;
        }

        .invoice_content_parent .seller_table_heading {
            width: 100%;
            direction: rtl;
        }

        .invoice_content_parent .seller_table_heading .seller_table_heading_first_td {
            width: 50%;
            direction: rtl;
            text-align: right;
        }

        .invoice_content_parent .seller_table_heading .seller_table_heading_second_td {
            width: 50%;
            direction: ltr;
            text-align: left;
        }

        .invoice_content_parent .seller_name_table_heading {
            width: 100%;
            direction: rtl;
        }

        .invoice_content_parent .seller_name_table_heading .seller_name_table_heading_first_td {
            width: 50%;
            direction: rtl;
            text-align: right;
            background-color: #dedede;
            padding: 10px;
        }

        .invoice_content_parent .seller_name_table_heading .seller_name_table_heading_second_td {
            width: 50%;
            direction: ltr;
            text-align: left;
            background-color: #dedede;
            padding: 10px;
        }

        .invoice_content_parent .seller_trn_table_heading {
            width: 100%;
            direction: rtl;
        }

        .invoice_content_parent .seller_trn_table_heading .seller_trn_table_heading_first_td {
            width: 50%;
            direction: rtl;
            text-align: right;
            background-color: #dedede;
            padding: 10px;
        }

        .invoice_content_parent .seller_trn_table_heading .seller_trn_table_heading_second_td {
            width: 50%;
            direction: ltr;
            text-align: left;
            background-color: #dedede;
            padding: 10px;
        }

        .invoice_items_parent {
            margin-top: 8px;
            border-radius: 15px;
            border: 1px solid black;
            padding: 10px;
        }

        .items_table {
            width: 100%;
            direction: rtl;
            border-collapse: separate;
            border-spacing: 0;
        }

        .items_table td {
            text-align: center;
            font-size: 17px;
            font-weight: bold;
        }

        .items_table .items_table_header td {
            background-color: #dedede;
            padding: 5px;
        }

        .items_table .items_table_item_details td {
            padding: 15px;
        }

        .invoice_totals_table {
            border-collapse: collapse;
            width: 100%;
        }

        .invoice_totals_table td {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }

        .invoice_totals_table .invoice_total_td {
            border: 1px solid black;
            padding: 9px;
        }
    </style>
</head>

<body style="margin:0;padding:0;">
    <div class="base_container">
       
        <div class="invoice_details_container">
            <table class="invoice_details_parent_table">
                <tbody>
                    <tr>
                        <td class="invoice_details_parent_td_first">
                            <table>
                                <tbody>
                                <tr>
                                        <td>
                                            <h1 class="invoice_title">Simplified Tax invoice فاتورة ضريبية مبسطة</h1>
                                        </td>
                                </tr>
                                    <tr>
                                        <td>
                                            <h2>  الرقم التسلسلي   <?= $view_data['prevat']['IRN'] ?? '-' ?></h2>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>  تاريخ اصدار الفاتورة  <?= $view_data['prevat']['InvoiceIssueDate'] ?? '-' ?></h2>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>  تاريخ التوريد   <?= $view_data['prevat']['DeliveryDateTime'] ?? '-' ?></h2>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                        <td class="invoice_details_parent_td_second">
                            <img class="qr_code" src="<?= $view_data['qr'] ?>">
                        </td>
                        <td class="invoice_details_parent_td_third">
                            <table>
                                <tbody>
                                    <tr>
                                        <td>
                                            <h2>Invoice reference number (IRN)</h2>
                                            <h4><?= $view_data['prevat']['IRN'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>Issue Date</h2>
                                            <h4><?= $view_data['prevat']['InvoiceIssueDate'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2>Supply Date</h2>
                                            <h4><?= $view_data['prevat']['DeliveryDateTime'] ?? '-' ?></h4>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="invoice_content_parent">
            <!-- Seller Details Begin -->
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2>هوية المورد</h2>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h2></h2>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>اسم المورد</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Seller Name</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_name_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_name_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['supplier']['VatName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%">
                    <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2></h2>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h2>Seller Identification</h2>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                    <h3>رقم تسجيل ضريبة القيمة المضافة</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                    <h3>VAT Registration Number</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_name_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_name_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['supplier']['VatNumber'] ?? '-'?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>رقم السجل التجاري</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Commercial Registration (CR)</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['supplier']['Crn'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="25%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>الرمز البريدي</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Postal Code</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_second_td" colspan="2">
                                        <h4><?= $view_data['supplier']['PostalNumber'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="25%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                    <h3>رمز الدولة</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                    <h3>Country Code</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_second_td" colspan="2">
                                    <h4><?= $view_data['supplier']['CountryName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <table class="seller_table_heading">
                <tbody>
                    <tr>
                        <td class="seller_table_heading_first_td">
                            <h2>العنوان</h2>
                        </td>
                        <td class="seller_table_heading_second_td">
                            <h2>Address</h2>
                        </td>
                    </tr>
                </tbody>
            </table>
            <table width="100%" dir="rtl">
                <tr>
                <td width="30%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h4>اسم الشارع</h4>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h4>Street Name</h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['supplier']['StreetName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="17%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>المدينة</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>City</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['supplier']['CityName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="28%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>رقم المبني</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Building Number</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td" colspan="2">
                                    <h4><?= $view_data['supplier']['BuildingNumber'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="25%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>اسم الحي</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>District</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_trn_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_trn_table_heading_first_td" colspan="2">
                                    <h4><?= $view_data['supplier']['SubDivisionName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <!-- Seller Details End -->
            <!-- Buyer Details Begin -->
    <div class="invoice_content_parent" style="margin: 10px 10px;">
            <table width="100%" dir="rtl">
                <tr>
                    <td width="50%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2>هوية العميل</h2>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h2></h2>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h3>اسم العميل</h3>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h3>Buyer Name</h3>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_name_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_name_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['prevat']['ClientName'] ?? '-' ?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="50%">
                    <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2></h2>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                        <h2>Buyer Identification</h2>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                    <h2> رقم الهوية </h2>
                                    </td>
                                    <td class="seller_table_heading_second_td">
                                    <h2> ID number </h2>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <table class="seller_name_table_heading">
                            <tbody>
                                <tr>
                                    <td class="seller_name_table_heading_first_td" colspan="2">
                                        <h4><?= $view_data['prevat']['csr'] ?? '-'?></h4>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>

            </div>
                <table width="100%" dir="rtl">
                <tr>
                <td width="30%">
                        <table class="seller_table_heading" style="margin-top:5px;">
                            <tbody>
                                <tr>
                                    <td></td>
                                    <td class="seller_table_heading_first_td">
                                        <h2> عقد </h2>
                                    </td>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h2><?= $view_data['prevat']['contract_id'] ?? '-' ?></h2>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="20%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2> إيجار سيارة </h2>
                                    </td>
                                    <td class="seller_trn_table_heading_first_td">
                                        <h2><?= $view_data['prevat']['PL'] ?? '-' ?></h2>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="28%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2> في الفترة من </h2>
                                    </td>
                                    <td class="seller_trn_table_heading_first_td">
                                    <h2><?= $view_data['prevat']['start'] ?? '-' ?></h2>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td width="25%">
                        <table class="seller_table_heading" style="margin-top: 10px;">
                            <tbody>
                                <tr>
                                    <td class="seller_table_heading_first_td">
                                        <h2> إلي </h2>
                                    </td>
                                    <td class="seller_trn_table_heading_first_td">
                                    <h2><?= $view_data['prevat']['DeliveryDateTime'] ?? '-' ?></h2>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>
            <div class="invoice_items_parent" style="margin: 8px 8px;">
                <table class="items_table" style="margin-top: 4px;">
                    <tbody>
                        <tr class="items_table_header">
                            <td>
                                <table>
                                    <tr>
                                        <td>إجمالي المبلغ شامل ضريبة القيمة المضافة</td>
                                    </tr>
                                    <tr>
                                        <td>Subtotal Inclusive of VAT</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>إجمالي المبلغ غير شامل ضريبة القيمة المضافة</td>
                                    </tr>
                                    <tr>
                                        <td>Subtotal Exclusive of VAT</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>مبلغ ضريبة القيمة المضافة</td>
                                    </tr>
                                    <tr>
                                        <td>VAT Amount</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>معدل ضريبة القيمة المضافة</td>
                                    </tr>
                                    <tr>
                                        <td>VAT Rate</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>الكمية</td>
                                    </tr>
                                    <tr>
                                        <td>Quantity</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>سعر الوحدة</td>
                                    </tr>
                                    <tr>
                                        <td>Unit Price</td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table>
                                    <tr>
                                        <td>وصف السلعة أو الخدمة</td>
                                    </tr>
                                    <tr>
                                        <td>Product or Service Description</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <?php foreach ($view_data['items'] as $item) { ?>
                            <tr class="items_table_item_details">
                                <td><?= $item['LineNetTotal'] ?> <?= $item['LineCurrency'] ?></td>
                                <td><?= $item['LineSubTotal'] ?> <?= $item['LineCurrency'] ?></td>
                                <td><?= $item['LineTaxTotal'] ?> <?= $item['LineCurrency'] ?></td>
                                <td><?= $view_data['prevat']['TaxPercentage'] ?> %</td>
                                <td><?= $item['LineQuantity'] ?></td>
                                <td><?= $item['LinePrice'] ?> <?= $item['LineCurrency'] ?></td>
                                <td><?= $item['LineName'] ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Item Details End -->
            <!-- Total Details Begin -->
            <div class="invoice_total_parent" style="margin: 8px 8px;">
                <table width="100%" style="direction: rtl;">
                    <tbody>
                        <tr>
                            <td width="30%">
                            <table class="invoice_totals_table">
                                    <tbody>
                                        <tr>
                                            <td class="invoice_total_td">
                                                <table width="100%">
                                                    <tr>
                                                        <td>حالة السداد Payment Type</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="invoice_total_td"><?= $view_data['prevat']['payment'] ?></td>
                                        </tr>
                                </tbody>
                            </table>
                            </td>
                            <td width="15%"></td>
                            <td width="55%">
                                <table class="invoice_totals_table">
                                    <tbody>
                                        <tr>
                                            <td class="invoice_total_td"><?= $view_data['prevat']['AllowanceChargeAmount'] ?> SAR</td>
                                            <td class="invoice_total_td">
                                                <table width="100%">
                                                    <tr>
                                                        <td>خصم Discount</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="invoice_total_td"><?= $view_data['prevat']['TaxExclusiveAmount'] ?> SAR</td>
                                            <td class="invoice_total_td">
                                                <table width="100%">
                                                    <tr>
                                                        <td>المبلغ الخاضع للضريبة Invoice Taxable Amount</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="invoice_total_td"><?= $view_data['prevat']['TaxAmount'] ?> SAR</td>
                                            <td class="invoice_total_td">
                                                <table width="100%">
                                                    <tr>
                                                        <td>اجمالى ضريبة القيمة المضافة VAT Total Amount</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="invoice_total_td"><?= $view_data['prevat']['TaxInclusiveAmount'] ?> SAR</td>
                                            <td class="invoice_total_td">
                                                <table width="100%">
                                                    <tr>
                                                        <td>إجمالي قيمة الفاتورة Inclusive of VAT</td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Total Details End -->
        </div>
    </div>
</body>

</html>