<?php

use App\Services\Zatca\Invoice\Client as ZatcaClient;
use App\Services\Zatca\Invoice\Supplier;
use App\Services\Zatca\Invoice\Delivery;
use App\Services\Zatca\Invoice\PaymentType;
use App\Services\Zatca\Invoice\PIH;
use App\Services\Zatca\Invoice\ReturnReason;
use App\Services\Zatca\Invoice\BillingReference;
use App\Services\Zatca\Invoice\AdditionalDocumentReference;
use App\Services\Zatca\Invoice\LegalMonetaryTotal;
use App\Services\Zatca\Invoice\TaxesTotal;
use App\Services\Zatca\Invoice\TaxSubtotal;
use App\Services\Zatca\Invoice\LineTaxCategory;
use App\Services\Zatca\Invoice\InvoiceLine;
use App\Services\Zatca\Invoice\AllowanceCharge;
use App\Services\Zatca\Invoice\InvoiceGenerator;


if(!function_exists('send_to_zatca')){
    function send_to_zatca($invoice){
        try {
            $document = $invoice->zatca_documents()->create(['invoice_id' => $invoice->id]);
            $document_type = '';
            $invoice_type = ($invoice->type == 'sales') ? '388' : '381';
            $stock_type = ($invoice->type == 'sales') ? 'out_qty' : 'in_qty';
            if(!empty($invoice->invoiceable->tax_number)){
                $client = (new ZatcaClient())
                ->setVatNumber($invoice->invoiceable->tax_number)
                ->setStreetName(@$invoice->invoiceable->national_address->street_name)
                ->setBuildingNumber($invoice->invoiceable->national_address->building_number)
                ->setPlotIdentification(@@$invoice->invoiceable->national_address->sub_number)
                ->setSubDivisionName(@$invoice->invoiceable->national_address->region->name)
                ->setCityName(@$invoice->invoiceable->national_address->city->name)
                ->setPostalNumber(@$invoice->invoiceable->national_address->postal_code)
                ->setCountryName('SA')
                ->setClientName($invoice->invoiceable->name);
                $document_type = '0100000';
            }else{
                $client = (new ZatcaClient())
                ->setCountryName('SA')
                ->setClientName($invoice->invoiceable->name);
                $document_type = '0200000';
            }
        
            $supplier = (new Supplier())
            ->setCrn(settings('commercial_register'))
            ->setStreetName(@get_settings()->national_address->street_name)
            ->setBuildingNumber(@get_settings()->national_address->building_number)
            ->setPlotIdentification(@get_settings()->national_address->sub_number)
            ->setSubDivisionName(@get_settings()->national_address->region->name)
            ->setCityName(@get_settings()->national_address->city->name)
            ->setPostalNumber(@get_settings()->national_address->postal_code)
            ->setCountryName('SA')
            ->setVatNumber(settings('tax_number'))
            ->setVatName(settings('name'));
        
            $delivery = (new Delivery())
            ->setDeliveryDateTime(Carbon::parse($invoice->supply_date)->format('Y-m-d'));
        
            $paymentType = (new PaymentType())
            ->setPaymentType('10');
        
            if($invoice->parent_invoice){

                $returnReason = (new ReturnReason())
                ->setReturnReason($invoice->notes);
            }

            $previous_hash = (new PIH())
            ->setPIH($document->pih);
        
            if($invoice->parent_invoice){

                $billingReference = (new BillingReference())
                ->setBillingReference(@$invoice->parent_invoice->invoice_id); // note this used when type credit or debit this value of parent invoice id

            }
            $additionalDocumentReference = (new AdditionalDocumentReference())
            ->setInvoiceID($document->icv);
        
            $legalMonetaryTotal = (new LegalMonetaryTotal())
            ->setTotalCurrency('SAR')
            ->setLineExtensionAmount($invoice->total)
            ->setTaxExclusiveAmount($invoice->sub_total)
            ->setTaxInclusiveAmount($invoice->net_total)
            ->setAllowanceTotalAmount(0)
            ->setPrepaidAmount(0)
            ->setPayableAmount($invoice->net_total);
        
            $taxesTotal = (new TaxesTotal())
            ->setTaxCurrencyCode('SAR')
            ->setTaxTotal($invoice->tax);
        
            $taxSubtotal = (new TaxSubtotal())
            ->setTaxCurrencyCode('SAR')
            ->setTaxableAmount($invoice->total)
            ->setTaxAmount($invoice->tax)
            ->setTaxCategory('S')
            ->setTaxPercentage(15)
            ->getElement();
        
            $itemTaxCategory = (new LineTaxCategory())
            ->setTaxCategory('S')
            ->setTaxPercentage(15)
            ->getElement();
    
            foreach($invoice->details as $detail){

                $invoiceLines[] = (new InvoiceLine())
                ->setLineID($detail->id)
                ->setLineName($detail->item_name)
                ->setLineCurrency('SAR')
                ->setLinePrice($detail->price)
                ->setLineQuantity($detail->{$stock_type})
                ->setLineSubTotal($detail->sub_total)
                ->setLineTaxTotal($detail->tax)
                ->setLineNetTotal($detail->net_total)
                ->setLineTaxCategories($itemTaxCategory)
                ->setLineDiscountReason('reason')
                ->setLineDiscountAmount(0)
                ->getElement();
            }
        
            $allowanceCharge = (new AllowanceCharge())
            ->setAllowanceChargeCurrency('SAR')
            ->setAllowanceChargeIndex('1')
            ->setAllowanceChargeAmount(0)
            ->setAllowanceChargeTaxCategory('S')
            ->setAllowanceChargeTaxPercentage(15)
            ->getElement();
        
            $response = (new InvoiceGenerator())
            ->setZatcaEnv(@get_settings()->zatca_stage)
            ->setZatcaLang(app()->getLocale())
            ->setInvoiceNumber($invoice->invoice_id)
            ->setInvoiceUuid($document->uuid) // this value from step 6
            ->setInvoiceIssueDate(Carbon::parse($invoice->created_at)->format('Y-m-d'))
            ->setInvoiceIssueTime(Carbon::parse($invoice->created_at)->format('H:i:s'))
            ->setInvoiceType($document_type,$invoice_type)
            ->setInvoiceCurrencyCode('SAR')
            ->setInvoiceTaxCurrencyCode('SAR');

            if($invoice->parent_invoice){
                $response = $response->setInvoiceBillingReference($billingReference);  //use this when document type is credit or debit
            }
            
            $response = $response->setInvoiceAdditionalDocumentReference($additionalDocumentReference)
            ->setInvoicePIH($previous_hash)
            ->setInvoiceSupplier($supplier)
            ->setInvoiceClient($client)
            ->setInvoiceDelivery($delivery)
            ->setInvoicePaymentType($paymentType);

            if($invoice->parent_invoice){
                $response = $response->setInvoiceReturnReason($returnReason); //use this when document type is credit or debit
            }
        
            $response = $response->setInvoiceLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceTaxesTotal($taxesTotal)
            ->setInvoiceTaxSubTotal($taxSubtotal)
            ->setInvoiceAllowanceCharges($allowanceCharge)
            ->setInvoiceLines(...$invoiceLines)
            ->setCertificateEncoded((!settings('is_production')) ? @get_settings()->certificate : @get_settings()->production_certificate)
            ->setPrivateKeyEncoded(@get_settings()->private_key)
            ->setCertificateSecret((!settings('is_production')) ? @get_settings()->secret : @get_settings()->production_secret)
            ->sendDocument((!settings('is_production')) ? false : true);
    
            if($response['success']){
                $document->update([
                    'hash' => $response['hash'],
                    'xml' => $response['xml'],
                    'signing_time' => Carbon::parse($response['signing_time']),
                ]);
            }
    
            $document->update([
                'sent_to_zatca' => $response['success'],
                'sent_to_zatca_status' => $response['response']->validationResults->status,
                'response' => json_encode($response,JSON_UNESCAPED_UNICODE),
            ]);
        } catch (\Exception $e) {
            throw new Exception($e->getMessage());
        }

    } 
}


/* zatca pdf to pdf / a3 example
public function print_pdf($setting_id,$invoice_id,$print_type,$id_type = 'invoiceID'){
    $setting = Setting::find($setting_id);
    $invoice = Invoice::where($id_type,$invoice_id)->where('setting_id',$setting_id)->first();
    $qrcode_result = $invoice->qrcode_result;
    $mpdf = new \Mpdf\Mpdf([
        'tempDir'=>storage_path('tempdir'),
         'PDFA' => true,
         'PDFAauto' => true,
         'fontDir' => [public_path('fonts/Almarai')],
         'fontdata' => [
             "almarai" => [
                 'R' => "Almarai-Regular.ttf",
                 'B' => "Almarai-Bold.ttf",
                 'I' => "Almarai-Light.ttf",
                 'BI' => "Almarai-ExtraBold.ttf",
                 'useOTL' => 0xFF,
                 'useKashida' => 75,
             ]
         ],
         'format' => [350, 435]
     ]);
     $mpdf->autoScriptToLang = true;
     $mpdf->autoLangToFont = true;
     $view_data = ['view' => false];
     $mpdf->WriteHTML(view('pdf.invoices',compact('view_data','invoice','qrcode_result','setting'))->render());
     if($invoice->sent_to_zatca){
        $xml_name = $this->xml_name($setting,$invoice);
        $temp = tmpfile();
        fwrite($temp, base64_decode($invoice->xml));
        fseek($temp, 0);
        $tmpfile_path = stream_get_meta_data($temp)['uri'];
        $mpdf->SetAssociatedFiles([[
            'name' => $xml_name,
            'mime' => 'text/xml',
            'description' => 'xml',
            'AFRelationship' => 'Alternative',
            'path' => $tmpfile_path
        ]]);
     }
     if($print_type == 'pdf'){
        $mpdf->Output();
     }elseif($print_type == 'binary'){
        return $mpdf->OutputBinaryData();
     }else{
        return base64_encode($mpdf->OutputBinaryData());
     }
}
*/